/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsStatus;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedAsymmetricKeyPairGenerator<T extends Parameters, P extends AsymmetricPublicKey, S extends AsymmetricPrivateKey>
implements AsymmetricKeyPairGenerator<T, P, S> {
    private T parameters;

    GuardedAsymmetricKeyPairGenerator(T t2) {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
        this.parameters = t2;
    }

    @Override
    public final T getParameters() {
        return this.parameters;
    }

    @Override
    public final AsymmetricKeyPair<P, S> generateKeyPair() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to generate key for unapproved algorithm in approved only mode");
        }
        return this.doGenerateKeyPair();
    }

    protected abstract AsymmetricKeyPair<P, S> doGenerateKeyPair();
}

