/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.OutputSigner;
import com.aspose.html.internal.ms.core.bc.crypto.OutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsEC;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSAOutputSigner;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSAOutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.general.EcDsaSigner;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedAsymmetricKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedSignatureOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.HMacDsaKCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.general.NullDigest;
import com.aspose.html.internal.ms.core.bc.crypto.general.RandomDsaKCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.general.Register;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcNamedDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;

public final class EC {
    public static final Algorithm ALGORITHM = FipsEC.ALGORITHM;
    public static final DSAParameters DSA = new DSAParameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.ECDSA), FipsSHS.Algorithm.SHA1);
    public static final DSAParameters DDSA = new DSAParameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.ECDDSA), FipsSHS.Algorithm.SHA1);

    private EC() {
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters(((NamedECDomainParameters)eCDomainParameters).getID(), eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
        }
        return new EcDomainParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricECPrivateKey asymmetricECPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(asymmetricECPrivateKey.getS(), EC.getDomainParams(asymmetricECPrivateKey.getDomainParameters()));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DSAOperatorFactory
    extends GuardedSignatureOperatorFactory<DSAParameters> {
        @Override
        protected OutputSigner<DSAParameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, DSAParameters dSAParameters) {
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
            Digest digest = dSAParameters.digestAlgorithm != null ? Register.createDigest(dSAParameters.digestAlgorithm) : new NullDigest();
            EcDsaSigner ecDsaSigner = dSAParameters.getAlgorithm() == DSA.getDigestAlgorithm() ? new EcDsaSigner(new RandomDsaKCalculator()) : new EcDsaSigner(new HMacDsaKCalculator(Register.createDigest(dSAParameters.digestAlgorithm)));
            final EcPrivateKeyParameters ecPrivateKeyParameters = EC.getLwKey(asymmetricECPrivateKey);
            return new DSAOutputSigner<DSAParameters>(ecDsaSigner, digest, dSAParameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(ecPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        protected OutputVerifier<DSAParameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, DSAParameters dSAParameters) {
            EcDsaSigner ecDsaSigner = new EcDsaSigner();
            Digest digest = dSAParameters.digestAlgorithm != null ? Register.createDigest(dSAParameters.digestAlgorithm) : new NullDigest();
            AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
            EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), EC.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
            ecDsaSigner.init(false, ecPublicKeyParameters);
            return new DSAOutputVerifier<DSAParameters>(ecDsaSigner, digest, dSAParameters);
        }
    }

    public static final class DSAParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        DSAParameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm) {
            super(generalAlgorithm);
            if (generalAlgorithm.basicVariation() == Variations.ECDDSA && digestAlgorithm == null) {
                throw new IllegalArgumentException("ECDDSA cannot be used with a NULL digest");
            }
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public DSAParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new DSAParameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm);
        }
    }

    public static final class KeyGenParameters
    extends GeneralParameters {
        private final ECDomainParameters domainParameters;

        public KeyGenParameters(ECDomainParameters eCDomainParameters) {
            this(ALGORITHM, eCDomainParameters);
        }

        public KeyGenParameters(DSAParameters dSAParameters, ECDomainParameters eCDomainParameters) {
            this((Algorithm)dSAParameters.getAlgorithm(), eCDomainParameters);
        }

        private KeyGenParameters(Algorithm algorithm, ECDomainParameters eCDomainParameters) {
            super(algorithm);
            this.domainParameters = eCDomainParameters;
        }

        public ECDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator {
        private final FipsEC.KeyPairGenerator kpGen;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.kpGen = new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters(keyGenParameters.domainParameters), secureRandom);
        }

        protected AsymmetricKeyPair doGenerateKeyPair() {
            AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey> asymmetricKeyPair = this.kpGen.generateKeyPair();
            final Algorithm algorithm = this.getParameters().getAlgorithm();
            final AsymmetricECPublicKey asymmetricECPublicKey = asymmetricKeyPair.getPublicKey();
            final AsymmetricECPrivateKey asymmetricECPrivateKey = asymmetricKeyPair.getPrivateKey();
            return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyPair>(){

                @Override
                public AsymmetricKeyPair run() {
                    return new AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey>(new AsymmetricECPublicKey(algorithm, asymmetricECPublicKey.getDomainParameters(), asymmetricECPublicKey.getW()), new AsymmetricECPrivateKey(algorithm, asymmetricECPrivateKey.getDomainParameters(), asymmetricECPrivateKey.getS(), asymmetricECPublicKey.getW()));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        ECDSA,
        ECDDSA;

    }
}

