/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.BasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcMqvPrivateParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcMqvPublicParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.math.ec.ECAlgorithms;
import com.aspose.html.internal.ms.core.bc.math.ec.ECConstants;
import com.aspose.html.internal.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import java.math.BigInteger;

class EcMqvBasicAgreement
implements BasicAgreement {
    EcMqvPrivateParameters privParams;

    EcMqvBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        this.privParams = (EcMqvPrivateParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        EcMqvPublicParameters ecMqvPublicParameters = (EcMqvPublicParameters)cipherParameters;
        EcPrivateKeyParameters ecPrivateKeyParameters = this.privParams.getStaticPrivateKey();
        if (!this.privParams.getStaticPrivateKey().getParameters().equals(ecMqvPublicParameters.getStaticPublicKey().getParameters())) {
            throw new IllegalKeyException("ECMQV public key components have wrong domain parameters");
        }
        ECPoint eCPoint = this.calculateMqvAgreement(ecPrivateKeyParameters.getParameters(), ecPrivateKeyParameters, this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), ecMqvPublicParameters.getStaticPublicKey(), ecMqvPublicParameters.getEphemeralPublicKey()).normalize();
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }

    private ECPoint calculateMqvAgreement(EcDomainParameters ecDomainParameters, EcPrivateKeyParameters ecPrivateKeyParameters, EcPrivateKeyParameters ecPrivateKeyParameters2, EcPublicKeyParameters ecPublicKeyParameters, EcPublicKeyParameters ecPublicKeyParameters2, EcPublicKeyParameters ecPublicKeyParameters3) {
        BigInteger bigInteger = ecDomainParameters.getN();
        int n2 = (bigInteger.bitLength() + 1) / 2;
        BigInteger bigInteger2 = ECConstants.ONE.shiftLeft(n2);
        ECCurve eCCurve = ecDomainParameters.getCurve();
        ECPoint[] eCPointArray = new ECPoint[]{ECAlgorithms.importPoint(eCCurve, ecPublicKeyParameters.getQ()), ECAlgorithms.importPoint(eCCurve, ecPublicKeyParameters2.getQ()), ECAlgorithms.importPoint(eCCurve, ecPublicKeyParameters3.getQ())};
        eCCurve.normalizeAll(eCPointArray);
        ECPoint eCPoint = eCPointArray[0];
        ECPoint eCPoint2 = eCPointArray[1];
        ECPoint eCPoint3 = eCPointArray[2];
        BigInteger bigInteger3 = eCPoint.getAffineXCoord().toBigInteger();
        BigInteger bigInteger4 = bigInteger3.mod(bigInteger2);
        BigInteger bigInteger5 = bigInteger4.setBit(n2);
        BigInteger bigInteger6 = ecPrivateKeyParameters.getD().multiply(bigInteger5).add(ecPrivateKeyParameters2.getD()).mod(bigInteger);
        BigInteger bigInteger7 = eCPoint3.getAffineXCoord().toBigInteger();
        BigInteger bigInteger8 = bigInteger7.mod(bigInteger2);
        BigInteger bigInteger9 = bigInteger8.setBit(n2);
        BigInteger bigInteger10 = ecDomainParameters.getH().multiply(bigInteger6).mod(bigInteger);
        return ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger9.multiply(bigInteger10).mod(bigInteger), eCPoint3, bigInteger10);
    }
}

