/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.fips.DsaKCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.fips.RandomDsaKCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import com.aspose.html.internal.ms.core.bc.math.ec.ECAlgorithms;
import com.aspose.html.internal.ms.core.bc.math.ec.ECConstants;
import com.aspose.html.internal.ms.core.bc.math.ec.ECMultiplier;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.internal.ms.core.bc.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

class EcDsaSigner
implements DSA,
ECConstants {
    private final DsaKCalculator kCalculator;
    private EcKeyParameters key;
    private SecureRandom random;

    public EcDsaSigner() {
        this.kCalculator = new RandomDsaKCalculator();
    }

    public EcDsaSigner(DsaKCalculator dsaKCalculator) {
        this.kCalculator = dsaKCalculator;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                this.key = (EcPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                if (this.kCalculator instanceof RandomDsaKCalculator) {
                    throw new IllegalArgumentException("No random provided where one required.");
                }
                this.key = (EcPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.key = (EcPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        ECPoint eCPoint;
        BigInteger bigInteger3;
        EcDomainParameters ecDomainParameters = this.key.getParameters();
        BigInteger bigInteger4 = ecDomainParameters.getN();
        BigInteger bigInteger5 = this.calculateE(bigInteger4, byArray);
        BigInteger bigInteger6 = ((EcPrivateKeyParameters)this.key).getD();
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(bigInteger4, bigInteger6, byArray);
        } else {
            this.kCalculator.init(bigInteger4, this.random);
        }
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            bigInteger2 = this.kCalculator.nextK();
        } while ((bigInteger3 = (eCPoint = eCMultiplier.multiply(ecDomainParameters.getG(), bigInteger2).normalize()).getAffineXCoord().toBigInteger().mod(bigInteger4)).equals(ZERO) || (bigInteger = bigInteger2.modInverse(bigInteger4).multiply(bigInteger5.add(bigInteger6.multiply(bigInteger3))).mod(bigInteger4)).equals(ZERO));
        return new BigInteger[]{bigInteger3, bigInteger};
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        EcDomainParameters ecDomainParameters = this.key.getParameters();
        BigInteger bigInteger3 = ecDomainParameters.getN();
        BigInteger bigInteger4 = this.calculateE(bigInteger3, byArray);
        if (bigInteger.compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ONE) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger2.modInverse(bigInteger3);
        BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5).mod(bigInteger3);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger5).mod(bigInteger3);
        ECPoint eCPoint2 = ecDomainParameters.getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger6, eCPoint = ((EcPublicKeyParameters)this.key).getQ(), bigInteger7).normalize();
        if (eCPoint3.isInfinity()) {
            return false;
        }
        BigInteger bigInteger8 = eCPoint3.getAffineXCoord().toBigInteger().mod(bigInteger3);
        return bigInteger8.equals(bigInteger);
    }

    protected BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        int n2 = bigInteger.bitLength();
        int n3 = byArray.length * 8;
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        if (n2 < n3) {
            bigInteger2 = bigInteger2.shiftRight(n3 - n2);
        }
        return bigInteger2;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

