/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.BasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DhParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DhPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DhPublicKeyParameters;
import java.math.BigInteger;

class DhBasicAgreement
implements BasicAgreement {
    private DhPrivateKeyParameters key;
    private DhParameters dhParams;

    DhBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        DhPrivateKeyParameters dhPrivateKeyParameters;
        this.key = dhPrivateKeyParameters = (DhPrivateKeyParameters)cipherParameters;
        this.dhParams = this.key.getParameters();
    }

    public int getFieldSize() {
        return (this.key.getParameters().getP().bitLength() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        DhPublicKeyParameters dhPublicKeyParameters = (DhPublicKeyParameters)cipherParameters;
        DhParameters dhParameters = dhPublicKeyParameters.getParameters();
        if (!dhParameters.getG().equals(this.dhParams.getG()) || !dhParameters.getP().equals(this.dhParams.getP())) {
            throw new IllegalKeyException("DH public key has wrong domain parameters");
        }
        return dhPublicKeyParameters.getY().modPow(this.key.getX(), this.dhParams.getP());
    }
}

