/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.fips.CipherKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsOperationError;
import com.aspose.html.internal.ms.core.bc.crypto.internal.KeyGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DesEdeParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DesParameters;

class DesEdeKeyGenerator
extends CipherKeyGenerator {
    private final FipsAlgorithm algorithm;

    public DesEdeKeyGenerator(FipsAlgorithm fipsAlgorithm) {
        this.algorithm = fipsAlgorithm;
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.strength = (keyGenerationParameters.getStrength() + 7) / 8;
        if (this.strength == 0 || this.strength == 21) {
            this.strength = 24;
        } else if (this.strength == 14) {
            this.strength = 16;
        } else if (this.strength != 24 && this.strength != 16) {
            throw new IllegalArgumentException("Key must be 192 or 128 bits long: " + this.algorithm.getName());
        }
    }

    public byte[] generateKey() {
        byte[] byArray = new byte[this.strength];
        int n2 = 0;
        do {
            this.random.nextBytes(byArray);
            DesParameters.setOddParity(byArray);
        } while (DesEdeParameters.isWeakKey(byArray, 0, byArray.length) && !DesEdeParameters.isRealEDEKey(byArray) && n2++ < 10);
        if (DesEdeParameters.isWeakKey(byArray, 0, byArray.length) || !DesEdeParameters.isRealEDEKey(byArray)) {
            throw new FipsOperationError("Failed to generate a valid TripleDES key: " + this.algorithm.getName());
        }
        return byArray;
    }
}

