/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ua.DSTU4145ECBinary;
import com.aspose.html.internal.ms.core.bc.asn1.ua.DSTU4145Params;
import com.aspose.html.internal.ms.core.bc.asn1.ua.DSTU4145PointEncoder;
import com.aspose.html.internal.ms.core.bc.asn1.ua.UAObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricDSTU4145Key;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DSTU4145Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.internal.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import java.io.IOException;

public final class AsymmetricDSTU4145PublicKey
extends AsymmetricDSTU4145Key
implements AsymmetricPublicKey {
    private ECPoint w;

    public AsymmetricDSTU4145PublicKey(Algorithm algorithm, DSTU4145Parameters dSTU4145Parameters, ECPoint eCPoint) {
        super(algorithm, dSTU4145Parameters);
        this.w = KeyUtils.validated(eCPoint);
    }

    public AsymmetricDSTU4145PublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricDSTU4145PublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, subjectPublicKeyInfo.getAlgorithm());
        this.w = KeyUtils.validated(AsymmetricDSTU4145PublicKey.parsePublicKey(this.getParameters(), subjectPublicKeyInfo));
    }

    private static ECPoint parsePublicKey(DSTU4145Parameters dSTU4145Parameters, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        try {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey());
            byte[] byArray = aSN1OctetString.getOctets();
            if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
                AsymmetricDSTU4145PublicKey.reverseBytes(byArray);
            }
            return DSTU4145PointEncoder.decodePoint(dSTU4145Parameters.getDomainParameters().getCurve(), byArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Invalid info structure in DSTU4145 public key");
        }
    }

    public ECPoint getW() {
        return this.w;
    }

    public byte[] getEncoded() {
        if (this.dstu4145Identifier != null) {
            byte[] byArray = DSTU4145PointEncoder.encodePoint(this.w);
            if (this.dstu4145Identifier.getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
                AsymmetricDSTU4145PublicKey.reverseBytes(byArray);
            }
            return KeyUtils.getEncodedSubjectPublicKeyInfo(this.dstu4145Identifier, new DEROctetString(byArray));
        }
        DSTU4145Parameters dSTU4145Parameters = this.getParameters();
        if (dSTU4145Parameters.getDomainParameters() instanceof NamedECDomainParameters) {
            NamedECDomainParameters namedECDomainParameters = (NamedECDomainParameters)dSTU4145Parameters.getDomainParameters();
            DSTU4145Params dSTU4145Params = new DSTU4145Params(namedECDomainParameters.getID(), dSTU4145Parameters.getDKE());
            byte[] byArray = DSTU4145PointEncoder.encodePoint(this.w);
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, dSTU4145Params), new DEROctetString(byArray));
        }
        if (dSTU4145Parameters.getDomainParameters().getCurve() instanceof ECCurve.AbstractF2m) {
            DSTU4145ECBinary dSTU4145ECBinary = new DSTU4145ECBinary(dSTU4145Parameters.getDomainParameters());
            byte[] byArray = DSTU4145PointEncoder.encodePoint(this.w);
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, new DSTU4145Params(dSTU4145ECBinary)), new DEROctetString(byArray));
        }
        throw new IllegalArgumentException("Unable to encode binary parameters");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AsymmetricDSTU4145PublicKey) {
            AsymmetricDSTU4145PublicKey asymmetricDSTU4145PublicKey = (AsymmetricDSTU4145PublicKey)object;
            return this.w.equals(asymmetricDSTU4145PublicKey.w) && this.getParameters().equals(asymmetricDSTU4145PublicKey.getParameters());
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.w.hashCode();
        n2 = 31 * n2 + this.getParameters().hashCode();
        return n2;
    }
}

