/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.RecipientOperator;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.JcePasswordRecipient;
import com.aspose.html.internal.ms.core.bc.jcajce.io.CipherInputStream;
import com.aspose.html.internal.ms.core.bc.operator.InputDecryptor;
import java.io.InputStream;
import java.security.Key;
import javax.crypto.Cipher;

public class JcePasswordEnvelopedRecipient
extends JcePasswordRecipient {
    public JcePasswordEnvelopedRecipient(char[] password) {
        super(password);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] derivedKey, byte[] encryptedContentEncryptionKey) throws CMSException {
        Key key = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, derivedKey, encryptedContentEncryptionKey);
        final Cipher cipher = this.helper.createContentCipher(key, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            public InputStream getInputStream(InputStream dataOut) {
                return new CipherInputStream(dataOut, cipher);
            }
        });
    }
}

