/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Selector;
import java.math.BigInteger;

class OriginatorId
implements Selector {
    private byte[] subjectKeyId;
    private X500Name issuer;
    private BigInteger serialNumber;

    public OriginatorId(byte[] subjectKeyId) {
        this.setSubjectKeyID(subjectKeyId);
    }

    private void setSubjectKeyID(byte[] subjectKeyId) {
        this.subjectKeyId = subjectKeyId;
    }

    public OriginatorId(X500Name issuer, BigInteger serialNumber) {
        this.setIssuerAndSerial(issuer, serialNumber);
    }

    private void setIssuerAndSerial(X500Name issuer, BigInteger serialNumber) {
        this.issuer = issuer;
        this.serialNumber = serialNumber;
    }

    public OriginatorId(X500Name issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        this.setIssuerAndSerial(issuer, serialNumber);
        this.setSubjectKeyID(subjectKeyId);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Object clone() {
        return new OriginatorId(this.issuer, this.serialNumber, this.subjectKeyId);
    }

    public int hashCode() {
        int n2 = Arrays.hashCode(this.subjectKeyId);
        if (this.serialNumber != null) {
            n2 ^= this.serialNumber.hashCode();
        }
        if (this.issuer != null) {
            n2 ^= this.issuer.hashCode();
        }
        return n2;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof OriginatorId)) {
            return false;
        }
        OriginatorId originatorId = (OriginatorId)o2;
        return Arrays.areEqual(this.subjectKeyId, originatorId.subjectKeyId) && this.equalsObj(this.serialNumber, originatorId.serialNumber) && this.equalsObj(this.issuer, originatorId.issuer);
    }

    private boolean equalsObj(Object a2, Object b2) {
        return a2 != null ? a2.equals(b2) : b2 == null;
    }

    public boolean match(Object obj) {
        return false;
    }
}

