/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DERSet;
import com.aspose.html.internal.ms.core.bc.asn1.cms.Attribute;
import com.aspose.html.internal.ms.core.bc.asn1.cms.AttributeTable;
import com.aspose.html.internal.ms.core.bc.asn1.cms.CMSAlgorithmProtection;
import com.aspose.html.internal.ms.core.bc.asn1.cms.CMSAttributes;
import com.aspose.html.internal.ms.core.bc.asn1.cms.Time;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cms.CMSAttributeTableGenerator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class DefaultSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultSignedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultSignedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attribute;
        Object object;
        Hashtable hashtable = DefaultSignedAttributeTableGenerator.copyHashTable(this.table);
        if (!hashtable.containsKey(CMSAttributes.contentType) && (object = ASN1ObjectIdentifier.getInstance(parameters.get("contentType"))) != null) {
            attribute = new Attribute(CMSAttributes.contentType, new DERSet((ASN1Encodable)object));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        if (!hashtable.containsKey(CMSAttributes.signingTime)) {
            object = new Date();
            attribute = new Attribute(CMSAttributes.signingTime, new DERSet(new Time((Date)object)));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        if (!hashtable.containsKey(CMSAttributes.messageDigest)) {
            object = (byte[])parameters.get("digest");
            attribute = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString((byte[])object)));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        if (!hashtable.contains(CMSAttributes.cmsAlgorithmProtect)) {
            object = new Attribute(CMSAttributes.cmsAlgorithmProtect, new DERSet(new CMSAlgorithmProtection((AlgorithmIdentifier)parameters.get("digestAlgID"), 1, (AlgorithmIdentifier)parameters.get("signatureAlgID"))));
            hashtable.put(((Attribute)object).getAttrType(), object);
        }
        return hashtable;
    }

    public AttributeTable getAttributes(Map parameters) {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }

    private static Hashtable copyHashTable(Hashtable paramsMap) {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = paramsMap.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            hashtable.put(k2, paramsMap.get(k2));
        }
        return hashtable;
    }
}

