/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Set;
import com.aspose.html.internal.ms.core.bc.asn1.cms.KEKRecipientInfo;
import com.aspose.html.internal.ms.core.bc.asn1.cms.KeyAgreeRecipientInfo;
import com.aspose.html.internal.ms.core.bc.asn1.cms.KeyTransRecipientInfo;
import com.aspose.html.internal.ms.core.bc.asn1.cms.PasswordRecipientInfo;
import com.aspose.html.internal.ms.core.bc.asn1.cms.RecipientInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cms.AuthAttributesProvider;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSReadable;
import com.aspose.html.internal.ms.core.bc.cms.CMSSecureReadable;
import com.aspose.html.internal.ms.core.bc.cms.KEKRecipientInformation;
import com.aspose.html.internal.ms.core.bc.cms.KeyAgreeRecipientInformation;
import com.aspose.html.internal.ms.core.bc.cms.KeyTransRecipientInformation;
import com.aspose.html.internal.ms.core.bc.cms.PasswordRecipientInformation;
import com.aspose.html.internal.ms.core.bc.cms.RecipientInformation;
import com.aspose.html.internal.ms.core.bc.cms.RecipientInformationStore;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class CMSEnvelopedHelper {
    CMSEnvelopedHelper() {
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set recipientInfos, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable) {
        return CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, messageAlgorithm, secureReadable, null);
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set recipientInfos, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ArrayList<RecipientInformation> arrayList = new ArrayList<RecipientInformation>();
        for (int i2 = 0; i2 != recipientInfos.size(); ++i2) {
            RecipientInfo recipientInfo = RecipientInfo.getInstance(recipientInfos.getObjectAt(i2));
            CMSEnvelopedHelper.readRecipientInfo(arrayList, recipientInfo, messageAlgorithm, secureReadable, additionalData);
        }
        return new RecipientInformationStore(arrayList);
    }

    private static void readRecipientInfo(List infos, RecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ASN1Encodable aSN1Encodable = info.getInfo();
        if (aSN1Encodable instanceof KeyTransRecipientInfo) {
            infos.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)aSN1Encodable, messageAlgorithm, secureReadable, additionalData));
        } else if (aSN1Encodable instanceof KEKRecipientInfo) {
            infos.add(new KEKRecipientInformation((KEKRecipientInfo)aSN1Encodable, messageAlgorithm, secureReadable, additionalData));
        } else if (aSN1Encodable instanceof KeyAgreeRecipientInfo) {
            KeyAgreeRecipientInformation.readRecipientInfo(infos, (KeyAgreeRecipientInfo)aSN1Encodable, messageAlgorithm, secureReadable, additionalData);
        } else if (aSN1Encodable instanceof PasswordRecipientInfo) {
            infos.add(new PasswordRecipientInformation((PasswordRecipientInfo)aSN1Encodable, messageAlgorithm, secureReadable, additionalData));
        }
    }

    static class CMSAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private CMSReadable readable;

        CMSAuthenticatedSecureReadable(AlgorithmIdentifier algorithm, CMSReadable readable) {
            this.algorithm = algorithm;
            this.readable = readable;
        }

        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }
    }

    static class CMSDigestAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private DigestCalculator digestCalculator;
        private CMSReadable readable;

        public CMSDigestAuthenticatedSecureReadable(DigestCalculator digestCalculator, CMSReadable readable) {
            this.digestCalculator = digestCalculator;
            this.readable = readable;
        }

        public InputStream getInputStream() throws IOException, CMSException {
            return new FilterInputStream(this.readable.getInputStream()){

                public int read() throws IOException {
                    int n2 = this.in.read();
                    if (n2 >= 0) {
                        CMSDigestAuthenticatedSecureReadable.this.digestCalculator.getOutputStream().write(n2);
                    }
                    return n2;
                }

                public int read(byte[] inBuf, int inOff, int inLen) throws IOException {
                    int n2 = this.in.read(inBuf, inOff, inLen);
                    if (n2 >= 0) {
                        CMSDigestAuthenticatedSecureReadable.this.digestCalculator.getOutputStream().write(inBuf, inOff, n2);
                    }
                    return n2;
                }
            };
        }

        public byte[] getDigest() {
            return this.digestCalculator.getDigest();
        }
    }

    static class CMSEnvelopedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private CMSReadable readable;

        CMSEnvelopedSecureReadable(AlgorithmIdentifier algorithm, CMSReadable readable) {
            this.algorithm = algorithm;
            this.readable = readable;
        }

        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }
    }
}

