/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetStringParser;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1SequenceParser;
import com.aspose.html.internal.ms.core.bc.asn1.cms.CompressedDataParser;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ContentInfoParser;
import com.aspose.html.internal.ms.core.bc.cms.CMSContentInfoParser;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSTypedStream;
import com.aspose.html.internal.ms.core.bc.operator.InputExpander;
import com.aspose.html.internal.ms.core.bc.operator.InputExpanderProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSCompressedDataParser
extends CMSContentInfoParser {
    public CMSCompressedDataParser(byte[] compressedData) throws CMSException {
        this(new ByteArrayInputStream(compressedData));
    }

    public CMSCompressedDataParser(InputStream compressedData) throws CMSException {
        super(compressedData);
    }

    public CMSTypedStream getContent(InputExpanderProvider expanderProvider) throws CMSException {
        try {
            CompressedDataParser compressedDataParser = new CompressedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
            ContentInfoParser contentInfoParser = compressedDataParser.getEncapContentInfo();
            InputExpander inputExpander = expanderProvider.get(compressedDataParser.getCompressionAlgorithmIdentifier());
            ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)contentInfoParser.getContent(4);
            return new CMSTypedStream(contentInfoParser.getContentType().getId(), inputExpander.getInputStream(aSN1OctetStringParser.getOctetStream()));
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading compressed content.", iOException);
        }
    }
}

