/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.selector.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.cert.selector.X509CertificateHolderSelector;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class JcaX509CertificateHolderSelector
extends X509CertificateHolderSelector {
    public JcaX509CertificateHolderSelector(X509Certificate certificate) {
        super(JcaX509CertificateHolderSelector.convertPrincipal(certificate.getIssuerX500Principal()), certificate.getSerialNumber(), JcaX509CertificateHolderSelector.getSubjectKeyId(certificate));
    }

    public JcaX509CertificateHolderSelector(X500Principal issuer, BigInteger serialNumber) {
        super(JcaX509CertificateHolderSelector.convertPrincipal(issuer), serialNumber);
    }

    public JcaX509CertificateHolderSelector(X500Principal issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        super(JcaX509CertificateHolderSelector.convertPrincipal(issuer), serialNumber, subjectKeyId);
    }

    private static X500Name convertPrincipal(X500Principal issuer) {
        if (issuer == null) {
            return null;
        }
        return X500Name.getInstance(issuer.getEncoded());
    }

    private static byte[] getSubjectKeyId(X509Certificate cert) {
        byte[] byArray = cert.getExtensionValue(Extension.subjectKeyIdentifier.getId());
        if (byArray != null) {
            return ASN1OctetString.getInstance(ASN1OctetString.getInstance(byArray).getOctets()).getOctets();
        }
        return null;
    }
}

