/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.path.validations;

import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.KeyUsage;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidation;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationContext;
import com.aspose.html.internal.ms.core.bc.cert.path.CertPathValidationException;
import com.aspose.html.internal.ms.core.bc.util.Memoable;

public class KeyUsageValidation
implements CertPathValidation {
    private boolean isMandatory;

    public KeyUsageValidation() {
        this(true);
    }

    public KeyUsageValidation(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        context.addHandledExtension(Extension.keyUsage);
        if (!context.isEndEntity()) {
            KeyUsage keyUsage = KeyUsage.fromExtensions(certificate.getExtensions());
            if (keyUsage != null) {
                if (!keyUsage.hasUsages(4)) {
                    throw new CertPathValidationException("Issuer certificate KeyUsage extension does not permit key signing");
                }
            } else if (this.isMandatory) {
                throw new CertPathValidationException("KeyUsage extension not present in CA certificate");
            }
        }
    }

    public Memoable copy() {
        return new KeyUsageValidation(this.isMandatory);
    }

    public void reset(Memoable other) {
        KeyUsageValidation keyUsageValidation = (KeyUsageValidation)other;
        this.isMandatory = keyUsageValidation.isMandatory;
    }
}

