/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.ocsp;

import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.OCSPObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.OCSPResponse;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.OCSPResponseStatus;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.ResponseBytes;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.BasicOCSPResp;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.OCSPException;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.OCSPResp;
import java.io.IOException;

public class OCSPRespBuilder {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;

    public OCSPResp build(int status, Object response) throws OCSPException {
        if (response == null) {
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), null));
        }
        if (response instanceof BasicOCSPResp) {
            DEROctetString dEROctetString;
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)response;
            try {
                dEROctetString = new DEROctetString(basicOCSPResp.getEncoded());
            }
            catch (IOException iOException) {
                throw new OCSPException("can't encode object.", iOException);
            }
            ResponseBytes responseBytes = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, dEROctetString);
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), responseBytes));
        }
        throw new OCSPException("unknown response object");
    }
}

