/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.ocsp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.CertID;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.OCSPException;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculatorProvider;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import java.io.OutputStream;
import java.math.BigInteger;

public class CertificateID {
    public static final AlgorithmIdentifier HASH_SHA1 = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
    private final CertID id;

    public CertificateID(CertID id2) {
        if (id2 == null) {
            throw new IllegalArgumentException("'id' cannot be null");
        }
        this.id = id2;
    }

    public CertificateID(DigestCalculator digestCalculator, X509CertificateHolder issuerCert, BigInteger number) throws OCSPException {
        this.id = CertificateID.createCertID(digestCalculator, issuerCert, new ASN1Integer(number));
    }

    public ASN1ObjectIdentifier getHashAlgOID() {
        return this.id.getHashAlgorithm().getAlgorithm();
    }

    public byte[] getIssuerNameHash() {
        return this.id.getIssuerNameHash().getOctets();
    }

    public byte[] getIssuerKeyHash() {
        return this.id.getIssuerKeyHash().getOctets();
    }

    public BigInteger getSerialNumber() {
        return this.id.getSerialNumber().getValue();
    }

    public boolean matchesIssuer(X509CertificateHolder issuerCert, DigestCalculatorProvider digCalcProvider) throws OCSPException {
        try {
            return CertificateID.createCertID(digCalcProvider.get(this.id.getHashAlgorithm()), issuerCert, this.id.getSerialNumber()).equals(this.id);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new OCSPException("unable to create digest calculator: " + operatorCreationException.getMessage(), operatorCreationException);
        }
    }

    public CertID toASN1Primitive() {
        return this.id;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof CertificateID)) {
            return false;
        }
        CertificateID certificateID = (CertificateID)o2;
        return this.id.toASN1Primitive().equals(certificateID.id.toASN1Primitive());
    }

    public int hashCode() {
        return this.id.toASN1Primitive().hashCode();
    }

    public static CertificateID deriveCertificateID(CertificateID original, BigInteger newSerialNumber) {
        return new CertificateID(new CertID(original.id.getHashAlgorithm(), original.id.getIssuerNameHash(), original.id.getIssuerKeyHash(), new ASN1Integer(newSerialNumber)));
    }

    private static CertID createCertID(DigestCalculator digCalc, X509CertificateHolder issuerCert, ASN1Integer serialNumber) throws OCSPException {
        try {
            OutputStream outputStream = digCalc.getOutputStream();
            outputStream.write(issuerCert.toASN1Structure().getSubject().getEncoded("DER"));
            outputStream.close();
            DEROctetString dEROctetString = new DEROctetString(digCalc.getDigest());
            SubjectPublicKeyInfo subjectPublicKeyInfo = issuerCert.getSubjectPublicKeyInfo();
            outputStream = digCalc.getOutputStream();
            outputStream.write(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            outputStream.close();
            DEROctetString dEROctetString2 = new DEROctetString(digCalc.getDigest());
            return new CertID(digCalc.getAlgorithmIdentifier(), dEROctetString, dEROctetString2, serialNumber);
        }
        catch (Exception exception) {
            throw new OCSPException("problem creating ID: " + exception, exception);
        }
    }
}

