/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.dane;

import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEEntry;
import com.aspose.html.internal.ms.core.bc.util.CollectionStore;
import com.aspose.html.internal.ms.core.bc.util.Selector;
import com.aspose.html.internal.ms.core.bc.util.Store;
import com.aspose.html.internal.ms.core.bc.util.StoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DANEEntryStore
implements Store {
    private final Map entries;

    DANEEntryStore(List entries) {
        HashMap<String, DANEEntry> hashMap = new HashMap<String, DANEEntry>();
        for (DANEEntry dANEEntry : entries) {
            hashMap.put(dANEEntry.getDomainName(), dANEEntry);
        }
        this.entries = Collections.unmodifiableMap(hashMap);
    }

    public Collection getMatches(Selector selector) throws StoreException {
        if (selector == null) {
            return this.entries.values();
        }
        ArrayList arrayList = new ArrayList();
        for (Object v2 : this.entries.values()) {
            if (!selector.match(v2)) continue;
            arrayList.add(v2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Store toCertificateStore() {
        Collection collection = this.getMatches((Selector)null);
        ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(collection.size());
        for (DANEEntry dANEEntry : collection) {
            arrayList.add(dANEEntry.getCertificate());
        }
        return new CollectionStore(arrayList);
    }
}

