/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.dane;

import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEEntry;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEEntrySelector;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEEntrySelectorFactory;
import com.aspose.html.internal.ms.core.bc.cert.dane.DANEException;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;

public class DANEEntryFactory {
    private final DANEEntrySelectorFactory selectorFactory;

    public DANEEntryFactory(DigestCalculator digestCalculator) {
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public DANEEntry createEntry(String emailAddress, X509CertificateHolder certificate) throws DANEException {
        return this.createEntry(emailAddress, 3, certificate);
    }

    public DANEEntry createEntry(String emailAddress, int certUsage, X509CertificateHolder certificate) throws DANEException {
        if (certUsage < 0 || certUsage > 3) {
            throw new DANEException("unknown certificate usage: " + certUsage);
        }
        DANEEntrySelector dANEEntrySelector = this.selectorFactory.createSelector(emailAddress);
        byte[] byArray = new byte[]{(byte)certUsage, 0, 0};
        return new DANEEntry(dANEEntrySelector.getDomainName(), byArray, certificate);
    }
}

