/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.EncryptedValue;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.EncryptedValuePadder;
import com.aspose.html.internal.ms.core.bc.operator.KeyWrapper;
import com.aspose.html.internal.ms.core.bc.operator.OperatorException;
import com.aspose.html.internal.ms.core.bc.operator.OutputEncryptor;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS8EncryptedPrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS8EncryptedPrivateKeyInfoBuilder;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedValueBuilder {
    private KeyWrapper wrapper;
    private OutputEncryptor encryptor;
    private EncryptedValuePadder padder;

    public EncryptedValueBuilder(KeyWrapper wrapper, OutputEncryptor encryptor) {
        this(wrapper, encryptor, null);
    }

    public EncryptedValueBuilder(KeyWrapper wrapper, OutputEncryptor encryptor, EncryptedValuePadder padder) {
        this.wrapper = wrapper;
        this.encryptor = encryptor;
        this.padder = padder;
    }

    public EncryptedValue build(char[] revocationPassphrase) throws CRMFException {
        return this.encryptData(this.padData(Strings.toUTF8ByteArray(revocationPassphrase)));
    }

    public EncryptedValue build(X509CertificateHolder holder) throws CRMFException {
        try {
            return this.encryptData(this.padData(holder.getEncoded()));
        }
        catch (IOException iOException) {
            throw new CRMFException("cannot encode certificate: " + iOException.getMessage(), iOException);
        }
    }

    public EncryptedValue build(PrivateKeyInfo privateKeyInfo) throws CRMFException {
        PKCS8EncryptedPrivateKeyInfoBuilder pKCS8EncryptedPrivateKeyInfoBuilder = new PKCS8EncryptedPrivateKeyInfoBuilder(privateKeyInfo);
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        AlgorithmIdentifier algorithmIdentifier2 = this.encryptor.getAlgorithmIdentifier();
        try {
            PKCS8EncryptedPrivateKeyInfo pKCS8EncryptedPrivateKeyInfo = pKCS8EncryptedPrivateKeyInfoBuilder.build(this.encryptor);
            DERBitString dERBitString = new DERBitString(this.wrapper.generateWrappedKey(this.encryptor.getKey()));
            AlgorithmIdentifier algorithmIdentifier3 = this.wrapper.getAlgorithmIdentifier();
            ASN1OctetString aSN1OctetString = null;
            return new EncryptedValue(algorithmIdentifier, algorithmIdentifier2, dERBitString, algorithmIdentifier3, aSN1OctetString, new DERBitString(pKCS8EncryptedPrivateKeyInfo.getEncryptedData()));
        }
        catch (IllegalStateException illegalStateException) {
            throw new CRMFException("cannot encode key: " + illegalStateException.getMessage(), illegalStateException);
        }
        catch (OperatorException operatorException) {
            throw new CRMFException("cannot wrap key: " + operatorException.getMessage(), operatorException);
        }
    }

    private EncryptedValue encryptData(byte[] data) throws CRMFException {
        DERBitString dERBitString;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = this.encryptor.getOutputStream(byteArrayOutputStream);
        try {
            outputStream.write(data);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("cannot process data: " + iOException.getMessage(), iOException);
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        AlgorithmIdentifier algorithmIdentifier2 = this.encryptor.getAlgorithmIdentifier();
        try {
            this.wrapper.generateWrappedKey(this.encryptor.getKey());
            dERBitString = new DERBitString(this.wrapper.generateWrappedKey(this.encryptor.getKey()));
        }
        catch (OperatorException operatorException) {
            throw new CRMFException("cannot wrap key: " + operatorException.getMessage(), operatorException);
        }
        AlgorithmIdentifier algorithmIdentifier3 = this.wrapper.getAlgorithmIdentifier();
        ASN1OctetString aSN1OctetString = null;
        DERBitString dERBitString2 = new DERBitString(byteArrayOutputStream.toByteArray());
        return new EncryptedValue(algorithmIdentifier, algorithmIdentifier2, dERBitString, algorithmIdentifier3, aSN1OctetString, dERBitString2);
    }

    private byte[] padData(byte[] data) {
        if (this.padder != null) {
            return this.padder.getPaddedData(data);
        }
        return data;
    }
}

