/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSAParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSACryptoServiceProvider;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.RandomNumberGenerator;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1Convert;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.u;

public final class t {
    private t() {
    }

    public static int a(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("data");
        }
        int n2 = 2;
        try {
            ASN1 aSN1 = new ASN1(byArray);
            if (aSN1.getTag() == 48 && aSN1.getCount() > 0) {
                ASN1 aSN12 = aSN1.get_Item(0);
                switch (aSN12.getTag()) {
                    case 2: {
                        n2 = 0;
                        break;
                    }
                    case 48: {
                        n2 = 1;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new CryptographicException("invalid ASN.1 data");
        }
        return n2;
    }

    public static class a {
        private String a;
        private byte[] b;
        private int c;
        private byte[] d;

        public a() {
        }

        public a(byte[] byArray) {
            this();
            this.c(byArray);
        }

        public String a() {
            return this.a;
        }

        public void a(String string) {
            this.a = string;
        }

        public byte[] b() {
            return this.d == null ? null : (byte[])this.d.clone();
        }

        public void a(byte[] byArray) {
            this.d = byArray == null ? null : (byte[])byArray.clone();
        }

        public byte[] c() {
            if (this.b == null) {
                RandomNumberGenerator randomNumberGenerator = RandomNumberGenerator.create();
                this.b = new byte[8];
                randomNumberGenerator.getBytes(this.b);
            }
            return (byte[])this.b.clone();
        }

        public void b(byte[] byArray) {
            this.b = (byte[])byArray.clone();
        }

        public int d() {
            return this.c;
        }

        public void a(int n2) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("value", "Nagative");
            }
            this.c = n2;
        }

        private void c(byte[] byArray) {
            ASN1 aSN1;
            ASN1 aSN12 = new ASN1(byArray);
            if (aSN12.getTag() != 48) {
                throw new CryptographicException("invalid EncryptedPrivateKeyInfo");
            }
            ASN1 aSN13 = aSN12.get_Item(0);
            if (aSN13.getTag() != 48) {
                throw new CryptographicException("invalid encryptionAlgorithm");
            }
            ASN1 aSN14 = aSN13.get_Item(0);
            if (aSN14.getTag() != 6) {
                throw new CryptographicException("invalid algorithm");
            }
            this.a = ASN1Convert.toOid(aSN14);
            if (aSN13.getCount() > 1) {
                aSN1 = aSN13.get_Item(1);
                if (aSN1.getTag() != 48) {
                    throw new CryptographicException("invalid parameters");
                }
                ASN1 aSN15 = aSN1.get_Item(0);
                if (aSN15.getTag() != 4) {
                    throw new CryptographicException("invalid salt");
                }
                this.b = aSN15.getValue();
                ASN1 aSN16 = aSN1.get_Item(1);
                if (aSN16.getTag() != 2) {
                    throw new CryptographicException("invalid iterationCount");
                }
                this.c = ASN1Convert.toInt32(aSN16);
            }
            if ((aSN1 = aSN12.get_Item(1)).getTag() != 4) {
                throw new CryptographicException("invalid EncryptedData");
            }
            this.d = aSN1.getValue();
        }

        public byte[] e() {
            ASN1 aSN1;
            ASN1 aSN12;
            if (this.a == null) {
                throw new CryptographicException("No algorithm OID specified");
            }
            ASN1 aSN13 = new ASN1(48);
            aSN13.add(ASN1Convert.fromOid(this.a));
            if (this.c > 0 || this.b != null) {
                aSN12 = new ASN1(4, this.b);
                aSN1 = ASN1Convert.fromInt32(this.c);
                ASN1 aSN14 = new ASN1(48);
                aSN14.add(aSN12);
                aSN14.add(aSN1);
                aSN13.add(aSN14);
            }
            aSN12 = new ASN1(4, this.d);
            aSN1 = new ASN1(48);
            aSN1.add(aSN13);
            aSN1.add(aSN12);
            return aSN1.getBytes();
        }
    }

    public static class c {
        private int a = 0;
        private String b;
        private byte[] c;
        private ArrayList d = new ArrayList();

        public c() {
        }

        public c(byte[] byArray) {
            this();
            this.c(byArray);
        }

        public String a() {
            return this.b;
        }

        public void a(String string) {
            this.b = string;
        }

        public ArrayList b() {
            return this.d;
        }

        public byte[] c() {
            if (this.c == null) {
                return null;
            }
            return (byte[])this.c.clone();
        }

        public void a(byte[] byArray) {
            if (byArray == null) {
                throw new ArgumentNullException("PrivateKey");
            }
            this.c = (byte[])byArray.clone();
        }

        public int d() {
            return this.a;
        }

        public void a(int n2) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("value", "negative version");
            }
            this.a = n2;
        }

        private void c(byte[] byArray) {
            ASN1 aSN1 = new ASN1(byArray);
            if (aSN1.getTag() != 48) {
                throw new CryptographicException("invalid PrivateKeyInfo");
            }
            ASN1 aSN12 = aSN1.get_Item(0);
            if (aSN12.getTag() != 2) {
                throw new CryptographicException("invalid version");
            }
            this.a = aSN12.getValue()[0] & 0xFF;
            ASN1 aSN13 = aSN1.get_Item(1);
            if (aSN13.getTag() != 48) {
                throw new CryptographicException("invalid algorithm");
            }
            ASN1 aSN14 = aSN13.get_Item(0);
            if (aSN14.getTag() != 6) {
                throw new CryptographicException("missing algorithm OID");
            }
            this.b = ASN1Convert.toOid(aSN14);
            ASN1 aSN15 = aSN1.get_Item(2);
            this.c = aSN15.getValue();
            if (aSN1.getCount() > 3) {
                ASN1 aSN16 = aSN1.get_Item(3);
                for (int i2 = 0; i2 < aSN16.getCount(); ++i2) {
                    this.d.addItem(aSN16.get_Item(i2));
                }
            }
        }

        public byte[] e() {
            ASN1 aSN1 = new ASN1(48);
            aSN1.add(ASN1Convert.fromOid(this.b));
            aSN1.add(new ASN1(5));
            ASN1 aSN12 = new ASN1(48);
            aSN12.add(new ASN1(2, new byte[]{(byte)this.a}));
            aSN12.add(aSN1);
            aSN12.add(new ASN1(4, this.c));
            if (this.d.size() > 0) {
                ASN1 aSN13 = new ASN1(-96);
                for (ASN1 aSN14 : this.d) {
                    aSN13.add(aSN14);
                }
                aSN12.add(aSN13);
            }
            return aSN12.getBytes();
        }

        private static byte[] d(byte[] byArray) {
            int n2 = 0;
            int n3 = byArray.length;
            if (byArray[0] == 0) {
                n2 = 1;
                --n3;
            }
            byte[] byArray2 = new byte[n3];
            Buffer.blockCopy(Array.boxing(byArray), n2, Array.boxing(byArray2), 0, n3);
            return byArray2;
        }

        private static byte[] a(byte[] byArray, int n2) {
            if (byArray.length == n2) {
                return byArray;
            }
            if (byArray.length > n2) {
                return com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.d(byArray);
            }
            byte[] byArray2 = new byte[n2];
            Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray2), n2 - byArray.length, byArray.length);
            return byArray2;
        }

        public static RSA b(byte[] byArray) {
            ASN1 aSN1 = new ASN1(byArray);
            if (aSN1.getTag() != 48) {
                throw new CryptographicException("invalid private key format");
            }
            ASN1 aSN12 = aSN1.get_Item(0);
            if (aSN12.getTag() != 2) {
                throw new CryptographicException("missing version");
            }
            if (aSN1.getCount() < 9) {
                throw new CryptographicException("not enough key parameters");
            }
            RSAParameters rSAParameters = new RSAParameters();
            rSAParameters.Modulus = com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.d(aSN1.get_Item(1).getValue());
            int n2 = rSAParameters.Modulus.length;
            int n3 = n2 >> 1;
            rSAParameters.D = com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.a(aSN1.get_Item(3).getValue(), n2);
            rSAParameters.DP = com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.a(aSN1.get_Item(6).getValue(), n3);
            rSAParameters.DQ = com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.a(aSN1.get_Item(7).getValue(), n3);
            rSAParameters.Exponent = com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.d(aSN1.get_Item(2).getValue());
            rSAParameters.InverseQ = com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.a(aSN1.get_Item(8).getValue(), n3);
            rSAParameters.P = com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.a(aSN1.get_Item(4).getValue(), n3);
            rSAParameters.Q = com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.a(aSN1.get_Item(5).getValue(), n3);
            RSA rSA = null;
            try {
                rSA = RSA.create();
                rSA.importParameters(rSAParameters.Clone());
            }
            catch (CryptographicException cryptographicException) {
                CspParameters cspParameters = new CspParameters();
                cspParameters.setFlags(1);
                rSA = new RSACryptoServiceProvider(cspParameters);
                rSA.importParameters(rSAParameters.Clone());
            }
            return rSA;
        }

        public static byte[] a(RSA rSA) {
            RSAParameters rSAParameters = rSA.exportParameters(true).Clone();
            ASN1 aSN1 = new ASN1(48);
            aSN1.add(new ASN1(2, new byte[]{0}));
            aSN1.add(ASN1Convert.fromUnsignedBigInteger(rSAParameters.Modulus));
            aSN1.add(ASN1Convert.fromUnsignedBigInteger(rSAParameters.Exponent));
            aSN1.add(ASN1Convert.fromUnsignedBigInteger(rSAParameters.D));
            aSN1.add(ASN1Convert.fromUnsignedBigInteger(rSAParameters.P));
            aSN1.add(ASN1Convert.fromUnsignedBigInteger(rSAParameters.Q));
            aSN1.add(ASN1Convert.fromUnsignedBigInteger(rSAParameters.DP));
            aSN1.add(ASN1Convert.fromUnsignedBigInteger(rSAParameters.DQ));
            aSN1.add(ASN1Convert.fromUnsignedBigInteger(rSAParameters.InverseQ));
            return aSN1.getBytes();
        }

        public static DSA a(byte[] byArray, DSAParameters dSAParameters) {
            ASN1 aSN1 = new ASN1(byArray);
            if (aSN1.getTag() != 2) {
                throw new CryptographicException("invalid private key format");
            }
            dSAParameters.X = com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.a(aSN1.getValue(), 20);
            DSA dSA = DSA.create();
            dSA.importParameters(dSAParameters.Clone());
            return dSA;
        }

        public static byte[] a(DSA dSA) {
            DSAParameters dSAParameters = dSA.exportParameters(true).Clone();
            return ASN1Convert.fromUnsignedBigInteger(dSAParameters.X).getBytes();
        }

        public static byte[] a(AsymmetricAlgorithm asymmetricAlgorithm) {
            if (asymmetricAlgorithm instanceof RSA) {
                return com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.a((RSA)asymmetricAlgorithm);
            }
            if (asymmetricAlgorithm instanceof DSA) {
                return com.aspose.html.internal.ms.core.System.Security.Cryptography.t$c.a((DSA)asymmetricAlgorithm);
            }
            throw new CryptographicException("Unknown asymmetric algorithm {0}", asymmetricAlgorithm.toString());
        }
    }

    public static final class b
    extends Enum {
        public static final int a = 0;
        public static final int b = 1;
        public static final int c = 2;

        static {
            Enum.register(new u((Class)b.class, Integer.class));
        }
    }
}

