/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1Convert;

public class X509Extension {
    protected String extnOid;
    protected boolean extnCritical;
    protected ASN1 extnValue;

    protected X509Extension() {
        this.extnCritical = false;
    }

    public X509Extension(ASN1 asn1) {
        if (asn1.getTag() != 48 || asn1.getCount() < 2) {
            throw new ArgumentException(StringExtensions.format("Invalid X.509 extension.", new Object[0]));
        }
        if (asn1.get_Item(0).getTag() != 6) {
            throw new ArgumentException(StringExtensions.format("Invalid X.509 extension.", new Object[0]));
        }
        this.extnOid = ASN1Convert.toOid(asn1.get_Item(0));
        this.extnCritical = asn1.get_Item(1).getTag() == 1 && (asn1.get_Item(1).getValue()[0] & 0xFF) == 255;
        this.extnValue = asn1.get_Item(asn1.getCount() - 1);
        if (this.extnValue.getTag() == 4 && this.extnValue.getLength() > 0 && this.extnValue.getCount() == 0) {
            try {
                ASN1 aSN1 = new ASN1(this.extnValue.getValue());
                this.extnValue.setValue(null);
                this.extnValue.add(aSN1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.decode();
    }

    public X509Extension(X509Extension extension) {
        if (extension == null) {
            throw new ArgumentNullException("extension");
        }
        if (extension.getValue() == null || extension.getValue().getTag() != 4 || extension.getValue().getCount() != 1) {
            throw new ArgumentException(StringExtensions.format("Invalid X.509 extension.", new Object[0]));
        }
        this.extnOid = extension.getOid();
        this.extnCritical = extension.getCritical();
        this.extnValue = extension.getValue();
        this.decode();
    }

    protected void decode() {
    }

    protected void encode() {
    }

    public ASN1 getASN1() {
        ASN1 aSN1 = new ASN1(48);
        aSN1.add(ASN1Convert.fromOid(this.extnOid));
        if (this.extnCritical) {
            aSN1.add(new ASN1(1, new byte[]{-1}));
        }
        this.encode();
        aSN1.add(this.extnValue);
        return aSN1;
    }

    public String getOid() {
        return this.extnOid;
    }

    public boolean getCritical() {
        return this.extnCritical;
    }

    public void setCritical(boolean value) {
        this.extnCritical = value;
    }

    public String getName() {
        return this.extnOid;
    }

    public ASN1 getValue() {
        if (this.extnValue == null) {
            this.encode();
        }
        return this.extnValue;
    }

    public boolean equals(Object obj) {
        X509Extension x509Extension;
        if (obj == null) {
            return false;
        }
        X509Extension x509Extension2 = x509Extension = obj instanceof X509Extension ? (X509Extension)obj : null;
        if (x509Extension == null) {
            return false;
        }
        if (this.extnCritical != x509Extension.extnCritical) {
            return false;
        }
        if (!StringExtensions.equals(this.extnOid, x509Extension.extnOid)) {
            return false;
        }
        if (this.extnValue.getLength() != x509Extension.extnValue.getLength()) {
            return false;
        }
        for (int i2 = 0; i2 < this.extnValue.getLength(); ++i2) {
            if (this.extnValue.get_Item(i2) == x509Extension.extnValue.get_Item(i2)) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes() {
        return this.getASN1().getBytes();
    }

    public int hashCode() {
        return this.extnOid.hashCode();
    }

    private void a(msStringBuilder msStringBuilder2, int n2, int n3) {
        int n4;
        byte[] byArray = this.extnValue.getValue();
        int n5 = n3;
        for (n4 = 0; n4 < 8; ++n4) {
            if (n4 < n2) {
                msStringBuilder2.append(ByteExtensions.toString(byArray[n5++], "X2", CultureInfo.getInvariantCulture()));
                msStringBuilder2.append(" ");
                continue;
            }
            msStringBuilder2.append("   ");
        }
        msStringBuilder2.append("  ");
        n5 = n3;
        for (n4 = 0; n4 < n2; ++n4) {
            byte by2;
            if (((by2 = byArray[n5++]) & 0xFF) < 32) {
                msStringBuilder2.append(".");
                continue;
            }
            msStringBuilder2.append(Convert.toChar(by2));
        }
        msStringBuilder2.append(Environment.NewLine);
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        int n2 = this.extnValue.getLength() >> 3;
        int n3 = this.extnValue.getLength() - (n2 << 3);
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(msStringBuilder2, 8, n4);
            n4 += 8;
        }
        this.a(msStringBuilder2, n3, n4);
        return msStringBuilder2.toString();
    }

    public static X509Extension fromJava(byte[] data, String oid, boolean isCritical) {
        X509Extension x509Extension = new X509Extension();
        x509Extension.extnOid = oid;
        x509Extension.extnCritical = isCritical;
        x509Extension.extnValue = new ASN1(data);
        return x509Extension;
    }
}

