/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSingle;

public class PngChunkBKGD
extends PngChunkSingle {
    public static final String ID = "bKGD";
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;

    public PngChunkBKGD(ImageInfo info) {
        super(ID, info);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = null;
        if (this.imgInfo.greyscale) {
            chunkRaw = this.createEmptyChunk(2, true);
            PngHelperInternal.writeInt2tobytes(this.a, chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            chunkRaw = this.createEmptyChunk(1, true);
            chunkRaw.data[0] = (byte)this.e;
        } else {
            chunkRaw = this.createEmptyChunk(6, true);
            PngHelperInternal.writeInt2tobytes(this.b, chunkRaw.data, 0);
            PngHelperInternal.writeInt2tobytes(this.c, chunkRaw.data, 0);
            PngHelperInternal.writeInt2tobytes(this.d, chunkRaw.data, 0);
        }
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw c2) {
        if (this.imgInfo.greyscale) {
            this.a = PngHelperInternal.readInt2fromBytes(c2.data, 0);
        } else if (this.imgInfo.indexed) {
            this.e = c2.data[0] & 0xFF;
        } else if (c2.data.length >= 6) {
            this.b = PngHelperInternal.readInt2fromBytes(c2.data, 0);
            this.c = PngHelperInternal.readInt2fromBytes(c2.data, 2);
            this.d = PngHelperInternal.readInt2fromBytes(c2.data, 4);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk other) {
        PngChunkBKGD pngChunkBKGD = (PngChunkBKGD)other;
        this.a = pngChunkBKGD.a;
        this.b = pngChunkBKGD.b;
        this.c = pngChunkBKGD.b;
        this.d = pngChunkBKGD.b;
        this.e = pngChunkBKGD.e;
    }

    public void setGray(int gray) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only gray images support this");
        }
        this.a = gray;
    }

    public int getGray() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only gray images support this");
        }
        return this.a;
    }

    public void setPaletteIndex(int i2) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed (pallete) images support this");
        }
        this.e = i2;
    }

    public int getPaletteIndex() {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed (pallete) images support this");
        }
        return this.e;
    }

    public void setRGB(int r2, int g2, int b2) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.b = r2;
        this.c = g2;
        this.d = b2;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.b, this.c, this.d};
    }
}

