/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkPredicate;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSPLT;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTextVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ChunksList {
    public static final int CHUNK_GROUP_0_IDHR = 0;
    public static final int CHUNK_GROUP_1_AFTERIDHR = 1;
    public static final int CHUNK_GROUP_2_PLTE = 2;
    public static final int CHUNK_GROUP_3_AFTERPLTE = 3;
    public static final int CHUNK_GROUP_4_IDAT = 4;
    public static final int CHUNK_GROUP_5_AFTERIDAT = 5;
    public static final int CHUNK_GROUP_6_END = 6;
    protected List<PngChunk> chunks = new ArrayList<PngChunk>();
    final ImageInfo imageInfo;

    public ChunksList(ImageInfo imfinfo) {
        this.imageInfo = imfinfo;
    }

    public HashMap<String, Integer> getChunksKeys() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (PngChunk pngChunk : this.chunks) {
            hashMap.put(pngChunk.id, hashMap.containsKey(pngChunk.id) ? hashMap.get(pngChunk.id) + 1 : 1);
        }
        return hashMap;
    }

    public ArrayList<PngChunk> getChunks() {
        return new ArrayList<PngChunk>(this.chunks);
    }

    protected static List<PngChunk> getXById(List<PngChunk> list, final String id2, final String innerid) {
        if (innerid == null) {
            return ChunkHelper.filterList(list, new ChunkPredicate(){

                @Override
                public boolean match(PngChunk c2) {
                    return c2.id.equals(id2);
                }
            });
        }
        return ChunkHelper.filterList(list, new ChunkPredicate(){

            @Override
            public boolean match(PngChunk c2) {
                if (!c2.id.equals(id2)) {
                    return false;
                }
                if (c2 instanceof PngChunkTextVar && !((PngChunkTextVar)c2).getKey().equals(innerid)) {
                    return false;
                }
                return !(c2 instanceof PngChunkSPLT) || ((PngChunkSPLT)c2).getPalName().equals(innerid);
            }
        });
    }

    public void appendReadChunk(PngChunk chunk, int chunkGroup) {
        chunk.setChunkGroup(chunkGroup);
        this.chunks.add(chunk);
    }

    public List<? extends PngChunk> getById(String id2) {
        return this.getById(id2, null);
    }

    public List<? extends PngChunk> getById(String id2, String innerid) {
        return ChunksList.getXById(this.chunks, id2, innerid);
    }

    public PngChunk getById1(String id2) {
        return this.getById1(id2, false);
    }

    public PngChunk getById1(String id2, boolean failIfMultiple) {
        return this.getById1(id2, null, failIfMultiple);
    }

    public PngChunk getById1(String id2, String innerid, boolean failIfMultiple) {
        List<? extends PngChunk> list = this.getById(id2, innerid);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1 && (failIfMultiple || !list.get(0).allowsMultiple())) {
            throw new PngjException("unexpected multiple chunks id=" + id2);
        }
        return list.get(list.size() - 1);
    }

    public List<PngChunk> getEquivalent(final PngChunk c2) {
        return ChunkHelper.filterList(this.chunks, new ChunkPredicate(){

            @Override
            public boolean match(PngChunk c22) {
                return ChunkHelper.equivalent(c22, c2);
            }
        });
    }

    public String toString() {
        return "ChunkList: read: " + this.chunks.size();
    }

    public String toStringFull() {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        stringBuilder.append("\n Read:\n");
        for (PngChunk pngChunk : this.chunks) {
            stringBuilder.append(pngChunk).append(" G=" + pngChunk.getChunkGroup() + "\n");
        }
        return stringBuilder.toString();
    }
}

