/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageLine;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjExceptionInternal;

class ImageLines {
    public final ImageInfo imgInfo;
    public final int channels;
    public final int bitDepth;
    public final ImageLine.SampleType sampleType;
    public final boolean samplesUnpacked;
    public final int elementsPerRow;
    public final int rowOffset;
    public final int nRows;
    public final int rowStep;
    public final int[][] scanlines;
    public final byte[][] scanlinesb;

    public ImageLines(ImageInfo imgInfo, ImageLine.SampleType stype, boolean unpackedMode, int rowOffset, int nRows, int rowStep) {
        this.imgInfo = imgInfo;
        this.channels = imgInfo.channels;
        this.bitDepth = imgInfo.bitDepth;
        this.sampleType = stype;
        this.samplesUnpacked = unpackedMode || !imgInfo.packed;
        this.elementsPerRow = unpackedMode ? imgInfo.samplesPerRow : imgInfo.samplesPerRowPacked;
        this.rowOffset = rowOffset;
        this.nRows = nRows;
        this.rowStep = rowStep;
        if (stype == ImageLine.SampleType.INT) {
            this.scanlines = new int[nRows][this.elementsPerRow];
            this.scanlinesb = null;
        } else if (stype == ImageLine.SampleType.BYTE) {
            this.scanlinesb = new byte[nRows][this.elementsPerRow];
            this.scanlines = null;
        } else {
            throw new PngjExceptionInternal("bad ImageLine initialization");
        }
    }

    public int imageRowToMatrixRow(int imrow) {
        int n2 = (imrow - this.rowOffset) / this.rowStep;
        return n2 < 0 ? 0 : (n2 < this.nRows ? n2 : this.nRows - 1);
    }

    public int imageRowToMatrixRowStrict(int imrow) {
        int n2 = (imrow -= this.rowOffset) >= 0 && imrow % this.rowStep == 0 ? imrow / this.rowStep : -1;
        return n2 < this.nRows ? n2 : -1;
    }

    public int matrixRowToImageRow(int mrow) {
        return mrow * this.rowStep + this.rowOffset;
    }

    public ImageLine getImageLineAtMatrixRow(int mrow) {
        if (mrow < 0 || mrow > this.nRows) {
            throw new PngjException("Bad row " + mrow + ". Should be positive and less than " + this.nRows);
        }
        ImageLine imageLine = this.sampleType == ImageLine.SampleType.INT ? new ImageLine(this.imgInfo, this.sampleType, this.samplesUnpacked, this.scanlines[mrow], null) : new ImageLine(this.imgInfo, this.sampleType, this.samplesUnpacked, null, this.scanlinesb[mrow]);
        imageLine.setRown(this.matrixRowToImageRow(mrow));
        return imageLine;
    }
}

