/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.jpeg;

import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.TransparentColorRenderProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.JpegExifData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.AdobeApp14Segment;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.IccSegment;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JFIFData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers.JpegEncodingController;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffRational;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.JpegOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.sources.StreamSource;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.jpeg.AsposeJpegImageWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.jpeg.CmykOrYcckRawWriter;
import com.aspose.html.internal.ms.lang.Operators;

class JpegImageSaver {
    JpegImageSaver() {
    }

    public static void saveJpeg(RasterImage imageToSave, Stream stream, JFIFData jfifData, JpegExifData exifData, JpegOptions options) {
        Object object;
        Object object2;
        JpegStream jpegStream = new JpegStream(stream);
        JpegImage.saveJpegHeader(jpegStream);
        if (options.getResolutionSettings() != null) {
            if (exifData != null) {
                exifData.setXResolution(new TiffRational(Operators.castToUInt32(options.getResolutionSettings().getHorizontalResolution(), 14), 1L));
                exifData.setYResolution(new TiffRational(Operators.castToUInt32(options.getResolutionSettings().getVerticalResolution(), 14), 1L));
                exifData.setResolutionUnit(2);
            } else {
                if (jfifData == null) {
                    jfifData = new JFIFData();
                }
                jfifData.setXDensity(Operators.castToInt16(options.getResolutionSettings().getHorizontalResolution(), 14));
                jfifData.setYDensity(Operators.castToInt16(options.getResolutionSettings().getVerticalResolution(), 14));
            }
        }
        if (jfifData != null) {
            JFIFData.write(jfifData, jpegStream);
        }
        JpegImage.saveExif(jpegStream, exifData);
        if (options.getColorType() == 3) {
            object2 = options.getCMYKColorProfile() != null ? options.getCMYKColorProfile().getStream() : IccProfileHelper.getDefaultCmykProfile().getStream();
            IccSegment.iccSegments((Stream)object2, stream);
            object = new AdobeApp14Segment();
            ((AdobeApp14Segment)object).setVersion(100);
            ((AdobeApp14Segment)object).setFlags0(0);
            ((AdobeApp14Segment)object).setFlags1(0);
            ((AdobeApp14Segment)object).setTransform((byte)2);
            AdobeApp14Segment.write(stream, (AdobeApp14Segment)object);
            options.setCMYKColorProfile(new StreamSource((Stream)object2));
            if (options.getRGBColorProfile() == null) {
                options.setRGBColorProfile(IccProfileHelper.getDefaultRGBProfile());
            }
        }
        if (options.getColorType() == 4) {
            object2 = new AdobeApp14Segment();
            ((AdobeApp14Segment)object2).setVersion(100);
            ((AdobeApp14Segment)object2).setFlags0(0);
            ((AdobeApp14Segment)object2).setFlags1(0);
            ((AdobeApp14Segment)object2).setTransform((byte)0);
            AdobeApp14Segment.write(stream, (AdobeApp14Segment)object2);
        }
        object2 = new RawDataSettings();
        object = JpegImage.getPixelDataFormat(options.getColorType());
        JpegEncodingController jpegEncodingController = new JpegEncodingController(imageToSave.getBounds().Clone(), options, jpegStream, (PixelDataFormat)object);
        JpegSaver jpegSaver = new JpegSaver(jpegStream, options, imageToSave, (PixelDataFormat)object, jpegEncodingController);
        ((RawDataSettings)object2).setPixelDataFormat((PixelDataFormat)object);
        JpegDataWriter jpegDataWriter = null;
        jpegDataWriter = AsposeJpegImageWriter.shouldProcessAsPureCmyk((JpegImage)imageToSave) ? new CmykOrYcckRawWriter(jpegSaver, PixelDataFormat.getCMYK()) : (AsposeJpegImageWriter.shouldProcessAsPureYcck((JpegImage)imageToSave) ? new CmykOrYcckRawWriter(jpegSaver, PixelDataFormat.getYcck()) : JpegDataWriter.getWriter(jpegSaver, options));
        if (imageToSave.isRawDataAvailable() && imageToSave.getDitheringSettings() == null && options.getColorType() != 3) {
            ((RawDataSettings)object2).setColorPalette(null);
            ((RawDataSettings)object2).setCustomColorConverter(imageToSave.getRawCustomColorConverter());
            ((RawDataSettings)object2).setDitheringMethod(imageToSave.getRawDitheringMethod());
            ((RawDataSettings)object2).setFallbackIndex(imageToSave.getRawFallbackIndex());
            ((RawDataSettings)object2).setIndexedColorConverter(imageToSave.getRawIndexedColorConverter());
            ((RawDataSettings)object2).setLineSize(imageToSave.getWidth() * ((RawDataSettings)object2).getPixelDataFormat().getChannelsCount());
            imageToSave.loadRawData(imageToSave.getBounds().Clone(), (RawDataSettings)object2, jpegSaver);
        } else if (imageToSave.hasTransparentColor()) {
            TransparentColorRenderProcessor transparentColorRenderProcessor = new TransparentColorRenderProcessor(imageToSave.getTransparentColor(), imageToSave.getBackgroundColor(), jpegDataWriter);
            imageToSave.loadPartialArgb32Pixels(imageToSave.getBounds().Clone(), transparentColorRenderProcessor);
        } else {
            imageToSave.loadPartialArgb32Pixels(imageToSave.getBounds().Clone(), jpegDataWriter);
        }
        JpegImage.writeImageTail(jpegStream);
    }
}

