/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.ico;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

class BmpInfoHeader {
    public int size;
    public int width;
    public int height;
    public short planes;
    public short bitCount;
    public int compression;
    public int imageSize;
    public int xpixelsPerM;
    public int ypixelsPerM;
    public int colorsUsed;
    public int colorsImportant;
    public int numColors;

    public BmpInfoHeader() {
        this.size = 40;
        this.width = 0;
        this.height = 0;
        this.planes = 1;
        this.bitCount = 0;
        this.numColors = 0;
        this.compression = 0;
        this.imageSize = 0;
        this.xpixelsPerM = 0;
        this.ypixelsPerM = 0;
        this.colorsUsed = 0;
        this.colorsImportant = 0;
    }

    BmpInfoHeader deepClone() {
        BmpInfoHeader bmpInfoHeader = new BmpInfoHeader();
        bmpInfoHeader.bitCount = this.bitCount;
        bmpInfoHeader.planes = this.planes;
        bmpInfoHeader.colorsImportant = this.colorsImportant;
        bmpInfoHeader.colorsUsed = this.colorsUsed;
        bmpInfoHeader.compression = this.compression;
        bmpInfoHeader.imageSize = this.imageSize;
        bmpInfoHeader.numColors = this.numColors;
        bmpInfoHeader.height = this.height;
        bmpInfoHeader.width = this.width;
        bmpInfoHeader.size = this.size;
        bmpInfoHeader.xpixelsPerM = this.xpixelsPerM;
        bmpInfoHeader.ypixelsPerM = this.ypixelsPerM;
        return bmpInfoHeader;
    }

    public BmpInfoHeader(ImageInputStream in2) throws IOException {
        this.size = in2.readInt();
        this.init(in2, this.size);
    }

    public BmpInfoHeader(ImageInputStream in2, boolean littleEndian) throws IOException {
        if (littleEndian) {
            this.size = BmpInfoHeader.intBack(in2.readInt());
            this.initBack(in2, this.size);
        } else {
            this.size = in2.readInt();
            this.init(in2, this.size);
        }
    }

    public BmpInfoHeader(ImageInputStream in2, int infoSize) throws IOException {
        this.init(in2, infoSize);
    }

    public BmpInfoHeader(ImageInputStream in2, int infoSize, boolean littleEndian) throws IOException {
        if (littleEndian) {
            this.initBack(in2, infoSize);
        } else {
            this.init(in2, infoSize);
        }
    }

    protected void init(ImageInputStream in2, int infoSize) throws IOException {
        this.size = infoSize;
        this.width = Math.abs(in2.readInt());
        this.height = Math.abs(in2.readInt());
        this.planes = in2.readShort();
        this.bitCount = in2.readShort();
        this.numColors = (int)Math.pow(2.0, this.bitCount);
        this.compression = in2.readInt();
        this.imageSize = in2.readInt();
        this.xpixelsPerM = in2.readInt();
        this.ypixelsPerM = in2.readInt();
        this.colorsUsed = in2.readInt();
        this.colorsImportant = in2.readInt();
    }

    protected void initBack(ImageInputStream in2, int infoSize) throws IOException {
        this.size = infoSize;
        this.width = Math.abs(BmpInfoHeader.intBack(in2.readInt()));
        this.height = Math.abs(BmpInfoHeader.intBack(in2.readInt()));
        this.planes = BmpInfoHeader.shortBack(in2.readShort());
        this.bitCount = BmpInfoHeader.shortBack(in2.readShort());
        this.numColors = (int)Math.pow(2.0, this.bitCount);
        this.compression = BmpInfoHeader.intBack(in2.readInt());
        this.imageSize = BmpInfoHeader.intBack(in2.readInt());
        this.xpixelsPerM = BmpInfoHeader.intBack(in2.readInt());
        this.ypixelsPerM = BmpInfoHeader.intBack(in2.readInt());
        this.colorsUsed = BmpInfoHeader.intBack(in2.readInt());
        this.colorsImportant = BmpInfoHeader.intBack(in2.readInt());
    }

    public void write(ImageOutputStream out) throws IOException {
        out.writeInt(BmpInfoHeader.intWBack(this.size));
        out.writeInt(BmpInfoHeader.intWBack(this.width));
        out.writeInt(BmpInfoHeader.intWBack(this.height));
        out.writeShort(BmpInfoHeader.shortWBack(this.planes));
        out.writeShort(BmpInfoHeader.shortWBack(this.bitCount));
        out.writeInt(BmpInfoHeader.intWBack(this.compression));
        out.writeInt(BmpInfoHeader.intWBack(this.imageSize));
        out.writeInt(BmpInfoHeader.intWBack(this.xpixelsPerM));
        out.writeInt(BmpInfoHeader.intWBack(this.ypixelsPerM));
        out.writeInt(BmpInfoHeader.intWBack(this.colorsUsed));
        out.writeInt(BmpInfoHeader.intWBack(this.colorsImportant));
    }

    public static short shortBack(short src) {
        return (short)((src & 0xFF) << 8 | src >> 8 & 0xFF);
    }

    public static int intBack(int src) {
        return (src & 0xFF) << 24 | (src & 0xFF00) << 8 | src >> 16 & 0xFF | src >> 24 & 0xFF;
    }

    public static int shortWBack(int src) {
        return src;
    }

    public static int intWBack(int src) {
        return src;
    }
}

