/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.DataBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.EntropyTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegComponentInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegEncoderState;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegScan;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegConstants;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegOrder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.JpegEntropyEncoder;

public class ProgressiveHuffmanEncoder
extends JpegEntropyEncoder {
    private static final int a = 1000;
    private final long[][] b = new long[4][];
    private int c;
    private int d;
    private int[] e;
    private byte f;
    private int g;
    private boolean h;
    private int[] i = new int[JpegConstants.MaxComponentsInScan + 1];

    public ProgressiveHuffmanEncoder(JpegEncoderState encoderState) {
        super(encoderState);
    }

    @Override
    public EntropyTable[] createHuffmanTables() {
        List<EntropyTable> list = new List<EntropyTable>();
        this.b();
        boolean[] blArray = new boolean[JpegConstants.MaxHuffTbls];
        JpegScan jpegScan = this.getEncoderState().getCurrentScan();
        boolean bl2 = (jpegScan.SpectralSelectorStart & 0xFF) == 0;
        for (int i2 = 0; i2 < jpegScan.Components.length; ++i2) {
            JpegComponentInfo jpegComponentInfo = this.getEncoderState().getJpegFrame().getComponentInfos()[jpegScan.Components[i2]];
            EntropyTable entropyTable = null;
            byte by2 = jpegComponentInfo.getACSelector();
            if (blArray[by2 & 0xFF]) continue;
            if (bl2) {
                if (jpegScan.getApproxBitPosHigh() != 0 || blArray[(by2 = jpegComponentInfo.getDCSelector()) & 0xFF]) continue;
                entropyTable = this.generateOptimalTable(this.b[by2 & 0xFF]);
                entropyTable.setTableClass((byte)0);
                entropyTable.setDestination(by2);
            } else {
                entropyTable = this.generateOptimalTable(this.b[by2]);
                entropyTable.setTableClass((byte)1);
                entropyTable.setDestination(by2);
            }
            list.addItem(entropyTable);
            blArray[by2 & 0xFF] = true;
        }
        this.h = false;
        return list.toArray(new EntropyTable[0]);
    }

    @Override
    public void encodeMCU(DataBlock[] dataBlocks) {
        switch (this.g) {
            case 0: {
                this.encodeDC(dataBlocks);
                break;
            }
            case 1: {
                this.encodeAC(dataBlocks);
                break;
            }
            case 2: {
                this.refineDC(dataBlocks);
                break;
            }
            case 3: {
                this.refineAC(dataBlocks);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException();
            }
        }
    }

    @Override
    public void finishPass() {
        this.b();
        this.a();
    }

    @Override
    public void gatherEntropy(DataBlock[] mcu) {
        this.h = true;
        this.encodeMCU(mcu);
    }

    @Override
    public void initialize() {
        this.i = new int[this.getEncoderState().getBlocksInMCU()];
        boolean bl2 = (this.getEncoderState().getCurrentScan().SpectralSelectorStart & 0xFF) == 0;
        JpegScan jpegScan = this.getEncoderState().getCurrentScan();
        for (int i2 = 0; i2 < jpegScan.Components.length; ++i2) {
            byte by2;
            int n2 = jpegScan.Components[i2];
            JpegComponentInfo jpegComponentInfo = this.getEncoderState().getJpegFrame().getComponentInfos()[n2];
            byte by3 = by2 = bl2 ? jpegComponentInfo.getDCSelector() : jpegComponentInfo.getACSelector();
            if (!bl2) {
                this.f = by2;
                if (this.e == null) {
                    this.e = new int[1000];
                }
            }
            if (this.b[by2 & 0xFF] == null) {
                this.b[by2 & 0xFF] = new long[257];
            }
            ArrayHelper.clear(this.b[by2 & 0xFF], 0, 257);
        }
        this.g = jpegScan.getApproxBitPosHigh() == 0 ? (bl2 ? 0 : 1) : (bl2 ? 2 : 3);
    }

    @Override
    public void startGatherEntropy() {
        this.h = true;
        boolean bl2 = (this.getEncoderState().getCurrentScan().SpectralSelectorStart & 0xFF) == 0;
        JpegScan jpegScan = this.getEncoderState().getCurrentScan();
        for (int i2 = 0; i2 < jpegScan.Components.length; ++i2) {
            byte by2;
            int n2 = jpegScan.Components[i2];
            JpegComponentInfo jpegComponentInfo = this.getEncoderState().getJpegFrame().getComponentInfos()[n2];
            this.f = by2 = bl2 ? jpegComponentInfo.getDCSelector() : jpegComponentInfo.getACSelector();
            if (this.b[by2 & 0xFF] == null) {
                this.b[by2 & 0xFF] = new long[257];
            }
            ArrayHelper.clear(this.b[by2 & 0xFF], 0, this.b[by2 & 0xFF].length);
        }
        if (jpegScan.getApproxBitPosHigh() == 0) {
            this.g = bl2 ? 0 : 1;
        } else {
            int n3 = this.g = bl2 ? 2 : 3;
            if (!bl2) {
                this.e = new int[1000];
            }
        }
    }

    public void encodeAC(DataBlock[] dataBlocks) {
        int n2 = 0;
        for (int i2 = this.getEncoderState().getCurrentScan().SpectralSelectorStart & 0xFF; i2 <= (this.getEncoderState().getCurrentScan().SpectralSelectorEnd & 0xFF); ++i2) {
            int n3;
            int n4 = dataBlocks[0].getData()[JpegOrder.NaturalOrder[i2]];
            if (n4 == 0) {
                ++n2;
                continue;
            }
            if (n4 < 0) {
                n4 = -n4;
                n3 = ~(n4 >>= this.getEncoderState().getCurrentScan().getApproxBitPosLow());
            } else {
                n3 = n4 >>= this.getEncoderState().getCurrentScan().getApproxBitPosLow();
            }
            if (n4 == 0) {
                ++n2;
                continue;
            }
            if (this.d > 0) {
                this.b();
            }
            while (n2 > 15) {
                this.a(false, this.f, 240);
                n2 -= 16;
            }
            int n5 = 1;
            while ((n4 >>= 1) != 0) {
                ++n5;
            }
            if (n5 > MaxHuffmanCoefBits) {
                throw new Exception("Bad dct coef");
            }
            this.a(false, this.f, (n2 << 4) + n5);
            this.a(n3, n5);
            n2 = 0;
        }
        if (n2 > 0) {
            ++this.d;
            if (this.d == Short.MAX_VALUE) {
                this.b();
            }
        }
    }

    public void encodeDC(DataBlock[] dataBlocks) {
        for (int i2 = 0; i2 < this.getEncoderState().getBlocksInMCU(); ++i2) {
            int n2 = dataBlocks[i2].getData()[0] >> this.getEncoderState().getCurrentScan().getApproxBitPosLow();
            int n3 = n2 - this.i[this.getEncoderState().getCurrentScan().getMCUMembership()[i2]];
            this.i[this.getEncoderState().getCurrentScan().getMCUMembership()[i2]] = n2;
            n2 = n3;
            if (n3 < 0) {
                n3 = -n3;
                --n2;
            }
            int n4 = 0;
            while (n3 != 0) {
                ++n4;
                n3 >>= 1;
            }
            if (n4 > MaxHuffmanCoefBits + 1) {
                throw new Exception("Bad dct coef");
            }
            int n5 = this.getEncoderState().getCurrentScan().getMCUMembership()[i2];
            this.a(true, this.getEncoderState().getJpegFrame().getComponentInfos()[n5].getDCSelector(), n4);
            if (n4 == 0) continue;
            this.a(n2, n4);
        }
    }

    public void refineAC(DataBlock[] dataBlocks) {
        int n2;
        int n3;
        int n4 = 0;
        int[] nArray = new int[JpegConstants.BlockSize2];
        JpegScan jpegScan = this.getEncoderState().getCurrentScan();
        for (n3 = jpegScan.SpectralSelectorStart & 0xFF; n3 <= (jpegScan.SpectralSelectorEnd & 0xFF); ++n3) {
            n2 = dataBlocks[0].get_Item(JpegOrder.NaturalOrder[n3]);
            if (n2 < 0) {
                n2 = -n2;
            }
            nArray[n3] = n2 >>= jpegScan.getApproxBitPosLow();
            if (n2 != 1) continue;
            n4 = n3;
        }
        n3 = 0;
        n2 = 0;
        int n5 = this.c;
        for (int i2 = jpegScan.SpectralSelectorStart & 0xFF; i2 <= (jpegScan.SpectralSelectorEnd & 0xFF); ++i2) {
            int n6 = nArray[i2];
            if (n6 == 0) {
                ++n3;
                continue;
            }
            while (n3 > 15 && i2 <= n4) {
                this.b();
                this.a(false, this.f, 240);
                n3 -= 16;
                this.b(n5, n2);
                n5 = 0;
                n2 = 0;
            }
            if (n6 > 1) {
                this.e[n5 + n2] = (char)(n6 & 1);
                ++n2;
                continue;
            }
            this.b();
            this.a(false, this.f, (n3 << 4) + 1);
            n6 = dataBlocks[0].getData()[JpegOrder.NaturalOrder[i2]] < 0 ? 0 : 1;
            this.a(n6, 1);
            this.b(n5, n2);
            n5 = 0;
            n2 = 0;
            n3 = 0;
        }
        if (n3 > 0 || n2 > 0) {
            ++this.d;
            this.c += n2;
            if (this.d == Short.MAX_VALUE || this.c > 1000 - JpegConstants.BlockSize2 + 1) {
                this.b();
            }
        }
    }

    public void refineDC(DataBlock[] dataBlocks) {
        for (int i2 = 0; i2 < this.getEncoderState().getBlocksInMCU(); ++i2) {
            short s2 = dataBlocks[i2].getData()[0];
            this.a(s2 >> this.getEncoderState().getCurrentScan().getApproxBitPosLow(), 1);
        }
    }

    private void a(int n2, int n3) {
        if (!this.h) {
            this.getEncoderState().getRawDataWriter().emitBits(n2, n3);
        }
    }

    private void b(int n2, int n3) {
        if (this.h) {
            return;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.a(this.e[n2 + i2], 1);
        }
    }

    private void a() {
        if (!this.h) {
            this.getEncoderState().getRawDataWriter().flush();
        }
    }

    private void b() {
        if (this.d > 0) {
            int n2 = this.d;
            int n3 = 0;
            while ((n2 >>= 1) != 0) {
                ++n3;
            }
            if (n3 > 14) {
                throw new Exception("Huff missing code");
            }
            this.a(false, this.f, n3 << 4);
            if (n3 != 0) {
                this.a(this.d, n3);
            }
            this.d = 0;
            this.b(0, this.c);
            this.c = 0;
        }
    }

    private void a(boolean bl2, byte by2, int n2) {
        if (this.h) {
            long[] lArray = this.b[by2 & 0xFF];
            int n3 = n2;
            lArray[n3] = lArray[n3] + 1L;
        } else {
            if (!bl2) {
                by2 = (byte)(16 + (by2 & 0xFF));
            }
            this.a(this.getEncoderState().getEntropyTables().get_Item(by2).getEhufco()[n2], this.getEncoderState().getEntropyTables().get_Item(by2).getEhufsi()[n2]);
        }
    }

    private void c() {
        this.b();
        this.getEncoderState().getRawDataWriter().flush();
    }

    private static final class MCUEncoder
    extends Enum {
        public static final int DCFirstEncoder = 0;
        public static final int ACFirstEncoder = 1;
        public static final int DCRefineEncoder = 2;
        public static final int ACRefineEncoder = 3;

        private MCUEncoder() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)MCUEncoder.class, Integer.class){
                {
                    this.addConstant("DCFirstEncoder", 0L);
                    this.addConstant("ACFirstEncoder", 1L);
                    this.addConstant("DCRefineEncoder", 2L);
                    this.addConstant("ACRefineEncoder", 3L);
                }
            });
        }
    }
}

