/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder;

import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.EntropyTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDecoderState;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegMCU;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRawDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegConstants;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.HuffmanBitParseState;

public abstract class JpegEntropyDecoder {
    private static final int[] a = new int[]{0, -1, -3, -7, -15, -31, -63, -127, -255, -511, -1023, -2047, -4095, -8191, -16383, -32767};
    private static final int[] b = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
    protected static final int BitBufferSize = 32;
    protected static final int MinGetBits = 25;
    protected final JpegRawDataReader RawDataReader;
    protected final int[] lastDC;
    protected JpegDecoderState decoderState;

    protected JpegEntropyDecoder(JpegDecoderState decoderState) {
        this.decoderState = decoderState;
        this.RawDataReader = decoderState.getRawDataReader();
        this.lastDC = new int[JpegConstants.MaxComponents];
    }

    public JpegDecoderState getDecoderState() {
        return this.decoderState;
    }

    public boolean decode(EntropyTable entropyTable, int[] result, HuffmanBitParseState[] state) {
        int n2 = 0;
        boolean bl2 = false;
        if (state[0].BitsLeft < JpegConstants.HuffLookahead) {
            if (!this.jpegFillBitBuffer(state, 0)) {
                result[0] = -1;
                return false;
            }
            if (state[0].BitsLeft < JpegConstants.HuffLookahead) {
                n2 = 1;
                bl2 = true;
            }
        }
        if (!bl2) {
            int n3 = JpegEntropyDecoder.peekBits(JpegConstants.HuffLookahead, state[0].Clone());
            n2 = entropyTable.getLookNbits()[n3];
            if (n2 != 0) {
                int[] nArray = new int[]{state[0].BitsLeft};
                JpegEntropyDecoder.dropBits(n2, nArray);
                state[0].BitsLeft = nArray[0];
                result[0] = entropyTable.getLookSym()[n3];
                return true;
            }
            n2 = JpegConstants.HuffLookahead + 1;
        }
        result[0] = this.jpegHuffDecode(state, entropyTable, n2);
        return result[0] >= 0;
    }

    protected int jpegHuffDecode(HuffmanBitParseState[] state, EntropyTable htbl, int minBits) {
        int n2 = minBits;
        if (!this.checkBitBuffer(n2, state)) {
            return -1;
        }
        int n3 = JpegEntropyDecoder.getBits(n2, state);
        while (n3 > htbl.getMaxCode()[n2]) {
            n3 <<= 1;
            if (!this.checkBitBuffer(1, state)) {
                return -1;
            }
            n3 |= JpegEntropyDecoder.getBits(1, state);
            ++n2;
        }
        if (n2 > 16) {
            return 0;
        }
        return htbl.getHuffVal()[n3 + htbl.getValPtr()[n2]] & 0xFF;
    }

    public abstract boolean decodeMCU(JpegMCU var1);

    public abstract void initializeScan();

    protected static int huffDecode(EntropyTable hTable) {
        throw new NotImplementedException();
    }

    protected boolean jpegFillBitBuffer(HuffmanBitParseState[] state, int nbits) {
        boolean bl2 = false;
        if (this.RawDataReader.getMetMarker() == 0) {
            while (state[0].BitsLeft < 25) {
                int n2 = 0;
                int[] nArray = new int[]{0};
                this.RawDataReader.getByte(nArray);
                n2 = nArray[0];
                if (n2 == 255) {
                    do {
                        nArray[0] = n2;
                        this.RawDataReader.getByte(nArray);
                    } while ((n2 = nArray[0]) == 255);
                    if (n2 == 0) {
                        n2 = 255;
                    } else {
                        this.RawDataReader.setMetMarker(n2);
                        bl2 = true;
                        break;
                    }
                }
                state[0].GetBuffer = state[0].GetBuffer << 8 | n2;
                state[0].BitsLeft += 8;
            }
        }
        if (bl2 && nbits > state[0].BitsLeft) {
            state[0].GetBuffer <<= 25 - state[0].BitsLeft;
            state[0].BitsLeft = 25;
        }
        return true;
    }

    protected static int huffExtend(int x2, int s2) {
        return x2 < b[s2] ? x2 + a[s2] : x2;
    }

    protected boolean checkBitBuffer(int nbits, HuffmanBitParseState[] state) {
        return state[0].BitsLeft >= nbits || this.jpegFillBitBuffer(state, nbits);
    }

    protected static int getBits(int nbits, HuffmanBitParseState[] state) {
        state[0].BitsLeft -= nbits;
        return state[0].GetBuffer >> state[0].BitsLeft & (1 << nbits) - 1;
    }

    protected static int peekBits(int nbits, HuffmanBitParseState state) {
        return state.GetBuffer >> state.BitsLeft - nbits & (1 << nbits) - 1;
    }

    protected static void dropBits(int nbits, int[] bitsLeft) {
        bitsLeft[0] = bitsLeft[0] - nbits;
    }
}

