/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.ImageLoadException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegFrame;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRawDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.lang.Operators;

public class JpegScan {
    public byte ApproxBit;
    public int[] Components;
    public byte SpectralSelectorEnd = (byte)63;
    public byte SpectralSelectorStart;
    private int[] a = new int[10];
    private int b;
    private int c;
    private int d;

    public JpegScan(byte ss, byte se, int ah2, int al2, int ncomps) {
        this(ss, se, ah2, al2, new int[ncomps]);
    }

    public JpegScan(byte ss, byte se, int ah2, int al2, int[] components) {
        this.setApproxBitPosHigh(ah2);
        this.setApproxBitPosLow(al2);
        this.SpectralSelectorStart = ss;
        this.SpectralSelectorEnd = se;
        this.Components = components;
    }

    public JpegScan() {
    }

    public int getApproxBitPosHigh() {
        return Operators.castToInt32(Operators.castToByte(Operators.castToInt32(this.ApproxBit, 6) >> 4, 9), 6);
    }

    public void setApproxBitPosHigh(int value) {
        this.ApproxBit = Operators.castToByte(Operators.castToInt32(this.ApproxBit, 6) | value << 4, 9);
    }

    public int getApproxBitPosLow() {
        return Operators.castToInt32(Operators.castToByte(Operators.castToInt32(this.ApproxBit, 6) & 0xF, 9), 6);
    }

    public void setApproxBitPosLow(int value) {
        this.ApproxBit = Operators.castToByte(Operators.castToInt32(this.ApproxBit, 6) & 0xF0 | value, 9);
    }

    public int[] getMCUMembership() {
        return this.a;
    }

    public void setMCUMembership(int[] value) {
        this.a = value;
    }

    public int getMaxH() {
        return this.b;
    }

    public void setMaxH(int value) {
        this.b = value;
    }

    public int getMaxV() {
        return this.c;
    }

    public void setMaxV(int value) {
        this.c = value;
    }

    public int getBlocksInMcu() {
        return this.d;
    }

    public void setBlocksInMcu(int value) {
        this.d = value;
    }

    public static JpegScan read(JpegRawDataReader stream, JpegFrame frame) {
        int n2;
        int n3;
        JpegScan jpegScan = new JpegScan();
        stream.skipInputData(2);
        int n4 = 0;
        int[] nArray = new int[]{0};
        stream.getByte(nArray);
        n4 = nArray[0];
        jpegScan.Components = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5;
            n2 = 0;
            int[] nArray2 = new int[]{0};
            stream.getByte(nArray2);
            n2 = nArray2[0];
            boolean bl2 = false;
            int n6 = 0;
            for (n5 = 0; n5 < frame.getComponentInfos().length; ++n5) {
                if ((frame.getComponentInfos()[n5].getId() & 0xFF) != n2) continue;
                bl2 = true;
                n6 = n5;
                break;
            }
            if (!bl2) {
                throw new FrameworkException(StringExtensions.Empty, new ImageLoadException("Corrupted Jpeg scan component id definition. Cannot load image."));
            }
            jpegScan.Components[n3] = n2;
            n5 = 0;
            int[] nArray3 = new int[]{0};
            stream.getByte(nArray3);
            n5 = nArray3[0];
            frame.getComponentInfos()[n6].setEntropySelector((byte)n5 & 0xFF);
        }
        n3 = 0;
        n2 = 0;
        int n7 = 0;
        int[] nArray4 = new int[]{0};
        stream.getByte(nArray4);
        n3 = nArray4[0];
        int[] nArray5 = new int[]{0};
        stream.getByte(nArray5);
        n2 = nArray5[0];
        int[] nArray6 = new int[]{0};
        stream.getByte(nArray6);
        n7 = nArray6[0];
        jpegScan.SpectralSelectorStart = (byte)n3;
        jpegScan.SpectralSelectorEnd = (byte)n2;
        jpegScan.ApproxBit = (byte)n7;
        return jpegScan;
    }

    public static void write(JpegStream resultStream, JpegFrame frame, JpegScan scan) {
        resultStream.writeByte((byte)-1);
        resultStream.writeByte((byte)-38);
        resultStream.writeShort(6 + 2 * scan.Components.length & 0xFFFF);
        resultStream.writeByte((byte)scan.Components.length);
        for (int i2 = 0; i2 < scan.Components.length; ++i2) {
            resultStream.writeByte(frame.getComponentInfos()[scan.Components[i2]].getId());
            byte by2 = (byte)(((frame.getComponentInfos()[scan.Components[i2]].getDCSelector() & 0xFF) << 4) + (frame.getComponentInfos()[scan.Components[i2]].getACSelector() & 0xFF));
            resultStream.writeByte(by2);
        }
        resultStream.writeByte(scan.SpectralSelectorStart);
        resultStream.writeByte(scan.SpectralSelectorEnd);
        resultStream.writeByte(scan.ApproxBit);
    }
}

