/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterCachedImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImagePixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.TransparentColorRenderProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.JpegException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.JpegExifData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.internal.CacheImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.AdobeApp14Segment;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.IccSegment;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JFIFData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers.JpegEncodingController;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffRational;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffBigEndianStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.JpegOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.sources.StreamSource;
import com.aspose.html.internal.ms.lang.Operators;

public final class JpegImage
extends RasterCachedImage {
    private int a;
    private JpegOptions b;
    private int c;
    private boolean d;
    private StreamSource e;
    private StreamSource f;

    public JpegImage(int w2, int h2, int[] colors) {
        this(w2, h2);
        CacheImage cacheImage = new CacheImage(this.getWidth(), this.getHeight(), colors);
        cacheImage.setPalette(this.getPalette());
        this.replaceDataReader(cacheImage);
    }

    public JpegImage(int width, int height) {
        this(new JpegOptions(), width, height);
    }

    public JpegImage(JpegOptions jpegOptions, int width, int height) {
        this.b = jpegOptions;
        this.c = width;
        this.a = height;
    }

    public JpegImage(int width, int height, int pixelFormat, IRasterImageArgb32PixelLoader jpegDataReader) {
        this.a(jpegDataReader, width, height);
        switch (pixelFormat) {
            case 0: {
                this.b.setColorType(0);
                break;
            }
            case 1: {
                this.b.setColorType(4);
                break;
            }
            case 3: {
                this.b.setColorType(1);
                break;
            }
            case 4: {
                this.b.setColorType(2);
                break;
            }
            case 5: {
                this.b.setColorType(3);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("pixelFormat");
            }
        }
    }

    public JpegOptions getJpegOptions() {
        return this.b;
    }

    @Override
    public int getBitsPerPixel() {
        return 8 * this.getRawDataFormat().getChannelsCount();
    }

    public String getComment() {
        return this.b.getComment();
    }

    public void setComment(String value) {
        this.b.setComment(value);
    }

    public JpegExifData getExifData() {
        return this.b.getExifData();
    }

    public void setExifData(JpegExifData value) {
        this.b.setExifData(value);
    }

    @Override
    public int getHeight() {
        return this.a;
    }

    @Override
    public double getHorizontalResolution() {
        if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
            return this.getExifData().getXResolution().getValueD();
        }
        return this.getJfif() != null ? (double)this.getJfif().getXDensity() : 0.0;
    }

    @Override
    public void setHorizontalResolution(double value) {
        throw new InvalidOperationException("JpegException: Use Jfif or ExifData for storing resolution.");
    }

    public JFIFData getJfif() {
        return this.b.getJfif();
    }

    public void setJfif(JFIFData value) {
        this.b.setJfif(value);
    }

    @Override
    public PixelDataFormat getRawDataFormat() {
        return JpegImage.getPixelDataFormat(this.b.getColorType());
    }

    @Override
    public double getVerticalResolution() {
        if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
            return this.getExifData().getYResolution().getValueD();
        }
        return this.getJfif() != null ? (double)this.getJfif().getYDensity() : 0.0;
    }

    @Override
    public void setVerticalResolution(double value) {
        throw new InvalidOperationException("FrameworkException: Use Jfif or ExifData for storing resolution.");
    }

    @Override
    public int getWidth() {
        return this.c;
    }

    public StreamSource getRGBColorProfile() {
        return this.e;
    }

    public void setRGBColorProfile(StreamSource value) {
        this.e = value;
    }

    public StreamSource getCMYKColorProfile() {
        return this.f;
    }

    public void setCMYKColorProfile(StreamSource value) {
        this.f = value;
    }

    public StreamSource getDestinationRGBColorProfile() {
        return this.b.getRGBColorProfile();
    }

    public void setDestinationRGBColorProfile(StreamSource value) {
        this.b.setRGBColorProfile(value);
    }

    public StreamSource getDestinationCMYKColorProfile() {
        return this.b.getCMYKColorProfile();
    }

    public void setDestinationCMYKColorProfile(StreamSource value) {
        this.b.setCMYKColorProfile(value);
    }

    public boolean getIgnoreEmbeddedColorProfile() {
        return this.d;
    }

    public void setIgnoreEmbeddedColorProfile(boolean value) {
        this.d = value;
    }

    public void autoRotate() {
        if (this.getExifData() != null) {
            switch (this.getExifData().getOrientation()) {
                case 1: {
                    break;
                }
                case 2: {
                    this.rotateFlip(4);
                    break;
                }
                case 3: {
                    this.rotateFlip(12);
                    break;
                }
                case 4: {
                    this.rotateFlip(8);
                    break;
                }
                case 5: {
                    this.rotateFlip(5);
                    break;
                }
                case 6: {
                    this.rotateFlip(1);
                    break;
                }
                case 7: {
                    this.rotateFlip(9);
                    break;
                }
                case 8: {
                    this.rotateFlip(13);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException();
                }
            }
            this.getExifData().setOrientation(1);
        }
    }

    static byte[] app1Data(JpegExifData exifData) {
        byte[] byArray = exifData.serializeExifData();
        if (byArray.length > 65528) {
            throw new JpegException("Exif segment is excessively big to be stored in jpeg file. Consider JpegExifData.SerializeExifData() method for result data size estimation.");
        }
        TiffBigEndianStream tiffBigEndianStream = new TiffBigEndianStream(new MemoryStream());
        tiffBigEndianStream.writeByte((byte)-1);
        tiffBigEndianStream.writeByte((byte)-31);
        tiffBigEndianStream.writeUShort(Operators.castToUInt16(byArray.length + 8, 9));
        byte[] byArray2 = new byte[]{69, 120, 105, 102, 0, 0};
        tiffBigEndianStream.write(byArray2);
        tiffBigEndianStream.write(byArray);
        byte[] byArray3 = tiffBigEndianStream.toBytes();
        return byArray3;
    }

    public static void saveJpeg(RasterImage imageToSave, Stream stream, JFIFData jfifData, JpegExifData exifData, JpegOptions options) {
        Object object;
        Object object2;
        JpegStream jpegStream = new JpegStream(stream);
        JpegImage.saveJpegHeader(jpegStream);
        if (options.getResolutionSettings() != null) {
            if (exifData != null) {
                exifData.setXResolution(new TiffRational(Operators.castToUInt32(options.getResolutionSettings().getHorizontalResolution(), 14), 1L));
                exifData.setYResolution(new TiffRational(Operators.castToUInt32(options.getResolutionSettings().getVerticalResolution(), 14), 1L));
                exifData.setResolutionUnit(2);
            } else {
                if (jfifData == null) {
                    jfifData = new JFIFData();
                }
                jfifData.setXDensity(Operators.castToInt16(options.getResolutionSettings().getHorizontalResolution(), 14));
                jfifData.setYDensity(Operators.castToInt16(options.getResolutionSettings().getVerticalResolution(), 14));
            }
        }
        if (jfifData != null) {
            JFIFData.write(jfifData, jpegStream);
        }
        JpegImage.saveExif(jpegStream, exifData);
        if (options.getColorType() == 3) {
            object2 = options.getCMYKColorProfile() != null ? options.getCMYKColorProfile().getStream() : IccProfileHelper.getDefaultCmykProfile().getStream();
            IccSegment.iccSegments((Stream)object2, stream);
            object = new AdobeApp14Segment();
            ((AdobeApp14Segment)object).setVersion(100);
            ((AdobeApp14Segment)object).setFlags0(0);
            ((AdobeApp14Segment)object).setFlags1(0);
            ((AdobeApp14Segment)object).setTransform((byte)2);
            AdobeApp14Segment.write(stream, (AdobeApp14Segment)object);
            options.setCMYKColorProfile(new StreamSource((Stream)object2));
            if (options.getRGBColorProfile() == null) {
                options.setRGBColorProfile(IccProfileHelper.getDefaultRGBProfile());
            }
        }
        if (options.getColorType() == 4) {
            object2 = new AdobeApp14Segment();
            ((AdobeApp14Segment)object2).setVersion(100);
            ((AdobeApp14Segment)object2).setFlags0(0);
            ((AdobeApp14Segment)object2).setFlags1(0);
            ((AdobeApp14Segment)object2).setTransform((byte)0);
            AdobeApp14Segment.write(stream, (AdobeApp14Segment)object2);
        }
        object2 = new RawDataSettings();
        object = JpegImage.getPixelDataFormat(options.getColorType());
        JpegEncodingController jpegEncodingController = new JpegEncodingController(imageToSave.getBounds().Clone(), options, jpegStream, (PixelDataFormat)object);
        JpegSaver jpegSaver = new JpegSaver(jpegStream, options, imageToSave, (PixelDataFormat)object, jpegEncodingController);
        ((RawDataSettings)object2).setPixelDataFormat((PixelDataFormat)object);
        JpegDataWriter jpegDataWriter = JpegDataWriter.getWriter(jpegSaver, options);
        if (imageToSave.isRawDataAvailable() && imageToSave.getDitheringSettings() == null && options.getColorType() != 3) {
            ((RawDataSettings)object2).setColorPalette(null);
            ((RawDataSettings)object2).setCustomColorConverter(imageToSave.getRawCustomColorConverter());
            ((RawDataSettings)object2).setDitheringMethod(imageToSave.getRawDitheringMethod());
            ((RawDataSettings)object2).setFallbackIndex(imageToSave.getRawFallbackIndex());
            ((RawDataSettings)object2).setIndexedColorConverter(imageToSave.getRawIndexedColorConverter());
            ((RawDataSettings)object2).setLineSize(imageToSave.getWidth() * ((RawDataSettings)object2).getPixelDataFormat().getChannelsCount());
            imageToSave.loadRawData(imageToSave.getBounds().Clone(), (RawDataSettings)object2, jpegSaver);
        } else if (imageToSave.hasTransparentColor()) {
            TransparentColorRenderProcessor transparentColorRenderProcessor = new TransparentColorRenderProcessor(imageToSave.getTransparentColor(), imageToSave.getBackgroundColor(), jpegDataWriter);
            imageToSave.loadPartialArgb32Pixels(imageToSave.getBounds().Clone(), transparentColorRenderProcessor);
        } else {
            imageToSave.loadPartialArgb32Pixels(imageToSave.getBounds().Clone(), jpegDataWriter);
        }
        JpegImage.writeImageTail(jpegStream);
    }

    public static PixelDataFormat getPixelDataFormat(int colorType) {
        PixelDataFormat pixelDataFormat;
        switch (colorType) {
            case 0: {
                pixelDataFormat = PixelDataFormat.getGrayscale();
                break;
            }
            case 1: {
                pixelDataFormat = PixelDataFormat.getYCbCr();
                break;
            }
            case 2: {
                pixelDataFormat = PixelDataFormat.getCMYK();
                break;
            }
            case 4: {
                pixelDataFormat = PixelDataFormat.getRgb24Bpp();
                break;
            }
            case 3: {
                pixelDataFormat = PixelDataFormat.getYcck();
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType");
            }
        }
        return pixelDataFormat;
    }

    @Override
    protected void saveData(Stream stream) {
        JpegImage.saveJpeg(this, stream, this.getJfif(), this.getExifData(), this.b);
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.c = newWidth;
        this.a = newHeight;
    }

    public static void saveExif(StreamContainer stream, JpegExifData exifData) {
        if (exifData == null) {
            return;
        }
        byte[] byArray = JpegImage.app1Data(exifData);
        stream.write(byArray, 0, byArray.length);
    }

    public static void saveJpegHeader(StreamContainer stream) {
        stream.writeByte((byte)-1);
        stream.writeByte((byte)-40);
    }

    public static void writeImageTail(JpegStream resultStream) {
        resultStream.writeByte((byte)-1);
        resultStream.writeByte((byte)-39);
    }

    private void a(RasterImagePixelLoader rasterImagePixelLoader) {
        this.a(rasterImagePixelLoader, rasterImagePixelLoader.getRasterImage().getWidth(), rasterImagePixelLoader.getRasterImage().getHeight());
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3) {
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        this.c = n2;
        this.a = n3;
        this.b = new JpegOptions();
    }

    public static void printMemoryStatus(String description) {
    }
}

