/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.JpegException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRawDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.lang.Operators;

public final class JFIFData {
    static final byte[] Marker = new byte[]{74, 70, 73, 70, 0};
    private byte a;
    private RasterImage b = null;
    private short c = (short)258;
    private short d;
    private short e;

    public byte getDensityUnits() {
        return this.a;
    }

    public void setDensityUnits(byte value) {
        this.a = value;
    }

    public RasterImage getThumbnail() {
        return this.b;
    }

    public void setThumbnail(RasterImage value) {
        RasterImage rasterImage = value;
        if (rasterImage != null) {
            if (rasterImage.getHeight() > 255 || rasterImage.getWidth() > 255) {
                throw new JpegException("Thumbnail width or height cannot be over 255 pixels.");
            }
            if (rasterImage.getWidth() * rasterImage.getHeight() * 3 + 16 > Operators.castToUInt16(65535, 8)) {
                throw new JpegException("Thumbnail data cannot be over 21839 pixels. Please, consider smaller thumbnail image.");
            }
        }
        this.b = value;
    }

    public short getVersion() {
        return this.c;
    }

    public void setVersion(short value) {
        this.c = value;
    }

    public short getXDensity() {
        return this.d;
    }

    public void setXDensity(short value) {
        this.d = value;
    }

    public short getYDensity() {
        return this.e;
    }

    public void setYDensity(short value) {
        this.e = value;
    }

    public static JFIFData read(JpegRawDataReader stream) {
        JFIFData jFIFData = null;
        int n2 = 0;
        int[] nArray = new int[]{0};
        stream.getTwoBytes(nArray);
        n2 = nArray[0];
        byte[] byArray = new byte[5];
        stream.getBytes(byArray, 5);
        String string = Encoding.getUTF8().getString(byArray, 0, byArray.length);
        if (StringExtensions.startsWith(string, "JFIF")) {
            jFIFData = new JFIFData();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int[] nArray2 = new int[]{0};
            stream.getTwoBytes(nArray2);
            n3 = nArray2[0];
            int[] nArray3 = new int[]{0};
            stream.getByte(nArray3);
            n4 = nArray3[0];
            jFIFData.a = (byte)n4;
            int[] nArray4 = new int[]{0};
            stream.getTwoBytes(nArray4);
            n5 = nArray4[0];
            int[] nArray5 = new int[]{0};
            stream.getTwoBytes(nArray5);
            n6 = nArray5[0];
            jFIFData.d = Operators.castToInt16(n5, 9);
            jFIFData.e = Operators.castToInt16(n6, 9);
            int[] nArray6 = new int[]{0};
            stream.getByte(nArray6);
            n7 = nArray6[0];
            int[] nArray7 = new int[]{0};
            stream.getByte(nArray7);
            n8 = nArray7[0];
            if (n8 != 0 && n7 != 0) {
                int n9 = n8 * n7;
                int[] nArray8 = new int[n9];
                for (int i2 = 0; i2 < n9; ++i2) {
                    int n10;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int[] nArray9 = new int[]{0};
                    stream.getByte(nArray9);
                    n11 = nArray9[0];
                    int[] nArray10 = new int[]{0};
                    stream.getByte(nArray10);
                    n12 = nArray10[0];
                    int[] nArray11 = new int[]{0};
                    stream.getByte(nArray11);
                    n13 = nArray11[0];
                    nArray8[i2] = n10 = (n11 << 16) + (n12 << 8) + n13;
                }
                jFIFData.b = new JpegImage(n7, n8);
                jFIFData.b.savePixels(new Rectangle(0, 0, n7, n8), nArray8);
            }
            jFIFData.c = Operators.castToInt16(n3, 9);
        }
        return jFIFData;
    }

    public static void write(JFIFData data, JpegStream stream) {
        if (data.b != null) {
            if (data.b.getHeight() > 255 || data.b.getWidth() > 255) {
                throw new JpegException("Thumbnail width or height cannot be over 255 pixels.");
            }
            if (data.b.getWidth() * data.b.getHeight() * 3 + 16 > Operators.castToUInt16(65535, 8)) {
                throw new JpegException("Thumbnail data cannot be over 21839 bytes long. Please, consider smaller thumbnail image.");
            }
        }
        stream.writeByte((byte)-1);
        stream.writeByte((byte)-32);
        stream.writeShort(Operators.castToUInt16(16 + (data.b != null ? data.b.getWidth() * data.b.getHeight() * 3 : 0), 9));
        stream.writeByte((byte)74);
        stream.writeByte((byte)70);
        stream.writeByte((byte)73);
        stream.writeByte((byte)70);
        stream.writeByte((byte)0);
        stream.writeByte((byte)1);
        stream.writeByte((byte)1);
        stream.writeByte(data.a);
        stream.writeShort(Operators.castToUInt16(data.d, 7));
        stream.writeShort(Operators.castToUInt16(data.e, 7));
        if (data.b != null) {
            stream.writeByte(Operators.castToByte(data.b.getWidth(), 9));
            stream.writeByte(Operators.castToByte(data.b.getHeight(), 9));
            int[] nArray = data.getThumbnail().loadPixels(new Rectangle(0, 0, data.b.getWidth(), data.b.getHeight()));
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                stream.writeByte(Operators.castToByte(n2 >> 16 & 0xFF, 9));
                stream.writeByte(Operators.castToByte(n2 >> 8 & 0xFF, 9));
                stream.writeByte(Operators.castToByte(n2 & 0xFF, 9));
            }
        } else {
            stream.writeByte((byte)0);
            stream.writeByte((byte)0);
        }
    }
}

