/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.BufferHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.DisposableObject;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterCachedImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImagePixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RgbEntriesPaletteHash;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.LzwVariableWidthBlockEncoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.GifImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifFrameBlockDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.IGifBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IAdvancedBufferProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.lang.Operators;

public final class GifFrameBlock
extends RasterCachedImage
implements IGifBlock {
    public static final int EXTENSION_LABEL = 44;
    public static final int IMAGE_DESCRIPTOR_SIZE = 10;
    private byte a;
    private int b;
    private int c;
    private int d;
    private int e;
    private byte f;

    public GifFrameBlock(int width, int height) {
        this(0, 0, width, height);
    }

    public GifFrameBlock(int left, int top, int width, int height) {
        this(null, left, top, width, height, null, false, false, 8);
    }

    public GifFrameBlock(int left, int top, int width, int height, IColorPalette colorPalette, boolean isPaletteSorted, boolean isGifFrameInterlaced, byte bitsPerPixel) {
        this(null, left, top, width, height, colorPalette, isPaletteSorted, isGifFrameInterlaced, bitsPerPixel);
    }

    public GifFrameBlock(RasterImage image) {
        this(image, 0, 0, false, false, 8);
    }

    public GifFrameBlock(RasterImage image, int left, int top) {
        this(image, left, top, false, false, 8);
    }

    public GifFrameBlock(RasterImage image, int left, int top, boolean isPaletteSorted, boolean isGifFrameInterlaced, byte lzwCodeSize) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        this.a(new RasterImagePixelLoader(image), left, top, isPaletteSorted, isGifFrameInterlaced, lzwCodeSize);
    }

    public GifFrameBlock(GifFrameBlockDataReader dataReader, int left, int top, int width, int height, IColorPalette colorPalette, boolean isPaletteSorted, boolean isGifFrameInterlaced, byte lzwCodeSize) {
        super(colorPalette);
        this.a(colorPalette, left, top, Operators.castToInt32(width, 8), Operators.castToInt32(height, 8), isPaletteSorted, isGifFrameInterlaced, lzwCodeSize);
        if (dataReader != null) {
            this.setDataLoader(dataReader);
            dataReader.setGifFrameBlock(this);
        }
    }

    @Override
    public int getWidth() {
        return this.b;
    }

    @Override
    public int getHeight() {
        return this.c;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return Operators.castToInt32(this.a, 6);
    }

    public boolean getInterlaced() {
        this.verifyNotDisposed();
        return (Operators.castToInt32(this.f, 6) & 0x40) != 0;
    }

    public void setInterlaced(boolean value) {
        this.verifyNotDisposed();
        byte by2 = this.f;
        by2 = value ? (byte)(Operators.castToInt32(by2, 6) | 0x40) : (byte)(Operators.castToInt32(by2, 6) & 0xBF);
        this.f = by2;
    }

    public boolean isPaletteSorted() {
        this.verifyNotDisposed();
        return (Operators.castToInt32(this.f, 6) & 0x20) != 0;
    }

    public void setPaletteSorted(boolean value) {
        this.verifyNotDisposed();
        byte by2 = this.f;
        by2 = value ? (byte)(Operators.castToInt32(by2, 6) | 0x20) : (byte)(Operators.castToInt32(by2, 6) & 0xDF);
        this.f = by2;
    }

    public byte getGifFrameBitsPerPixel() {
        this.verifyNotDisposed();
        return this.a;
    }

    public void setGifFrameBitsPerPixel(byte value) {
        this.verifyNotDisposed();
        if (Operators.castToInt32(value, 6) > 8) {
            throw new ArgumentOutOfRangeException("value", "Too big bits per pixel. The maximal allowed is 8 bits.");
        }
        if (Operators.castToInt32(value, 6) < 2) {
            throw new ArgumentOutOfRangeException("value", "Too small bits per pixel. The minimal allowed is 2 bits.");
        }
        this.a = value;
    }

    public int getLeft() {
        this.verifyNotDisposed();
        return this.d;
    }

    public void setLeft(int value) {
        this.verifyNotDisposed();
        this.d = value;
    }

    public int getTop() {
        this.verifyNotDisposed();
        return this.e;
    }

    public void setTop(int value) {
        this.verifyNotDisposed();
        this.e = value;
    }

    public byte getFlags() {
        this.verifyNotDisposed();
        return this.f;
    }

    public void setFlags(byte value) {
        this.verifyNotDisposed();
        if (Operators.castToInt32(this.f, 6) != Operators.castToInt32(value, 6)) {
            if ((Operators.castToInt32(value, 6) & 0x80) > 0 && this.getPalette() == null) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette is not present but flags indicate it is.");
            }
            if ((Operators.castToInt32(value, 6) & 0x80) == 0 && this.getPalette() != null) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette is present but flags indicate it is not.");
            }
            if (this.getPalette() != null && this.getPalette().getEntriesCount() != 2 << (Operators.castToInt32(value, 6) & 7)) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette entries count do not correspond to flags entries count.");
            }
            this.f = value;
        }
    }

    public GifGraphicsControlBlock getControlBlock() {
        GifGraphicsControlBlock gifGraphicsControlBlock = null;
        if (Operators.is(this.getContainer(), GifImage.class)) {
            IGifBlock[] iGifBlockArray = Operators.as(this.getContainer(), GifImage.class).getBlocks();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                IGifBlock iGifBlock;
                if (iGifBlockArray[i2] != this) continue;
                if (i2 <= 0 || !Operators.is(iGifBlock = iGifBlockArray[i2 - 1], GifGraphicsControlBlock.class)) break;
                gifGraphicsControlBlock = (GifGraphicsControlBlock)iGifBlock;
                break;
            }
        }
        return gifGraphicsControlBlock;
    }

    @Override
    public boolean hasTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return false;
        }
        return gifGraphicsControlBlock.hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean value) {
        if (this.getControlBlock() != null) {
            this.getControlBlock().setTransparentColor(value);
        } else if (Operators.is(this.getContainer(), GifImage.class)) {
            IGifBlock[] iGifBlockArray = Operators.as(this.getContainer(), GifImage.class).getBlocks();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                if (iGifBlockArray[i2] != this) continue;
                GifImage gifImage = Operators.as(this.getContainer(), GifImage.class);
                GifGraphicsControlBlock gifGraphicsControlBlock = new GifGraphicsControlBlock();
                gifGraphicsControlBlock.setTransparentColor(value);
                gifImage.insertBlock(i2, gifGraphicsControlBlock);
            }
        } else {
            throw new FrameworkException("The block does not belong to any image and transparent color could not be set.");
        }
    }

    @Override
    public int getTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return 0;
        }
        IColorPalette iColorPalette = this.a();
        if (iColorPalette != null && Operators.castToInt32(gifGraphicsControlBlock.getTransparentColorIndex(), 6) < iColorPalette.getEntriesCount()) {
            return iColorPalette.getArgb32Color(Operators.castToInt32(gifGraphicsControlBlock.getTransparentColorIndex(), 6));
        }
        return 0;
    }

    @Override
    public void setTransparentColor(int value) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        IColorPalette iColorPalette = this.a();
        int n2 = value;
        if (gifGraphicsControlBlock == null) {
            if (Operators.is(this.getContainer(), GifImage.class)) {
                IGifBlock[] iGifBlockArray = Operators.as(this.getContainer(), GifImage.class).getBlocks();
                for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                    if (iGifBlockArray[i2] != this) continue;
                    GifImage gifImage = Operators.as(this.getContainer(), GifImage.class);
                    GifGraphicsControlBlock gifGraphicsControlBlock2 = new GifGraphicsControlBlock();
                    gifGraphicsControlBlock2.setTransparentColorIndex(Operators.castToByte(iColorPalette.getNearestColorIndex(n2), 9));
                    gifGraphicsControlBlock2.setTransparentColor(true);
                    gifImage.insertBlock(i2, gifGraphicsControlBlock2);
                    return;
                }
            } else {
                throw new FrameworkException("The block does not belong to any image and transparent color could not be set.");
            }
        }
        if (iColorPalette != null) {
            gifGraphicsControlBlock.setTransparentColorIndex(Operators.castToByte(iColorPalette.getNearestColorIndex(n2), 9));
        }
    }

    public static IColorPalette getColorPalette(IColorPalette framePalette, IColorPalette containerPalette) {
        IColorPalette iColorPalette = null;
        if (framePalette != null) {
            iColorPalette = framePalette;
        } else if (containerPalette != null) {
            iColorPalette = containerPalette;
        }
        if (iColorPalette == null) {
            throw new GifImageException("Cannot work with GIF frame pixels since palette is not present neither in GIF image nor in GIF frame. Tip: setup color palette first.");
        }
        return iColorPalette;
    }

    public static byte createFlags(IColorPalette colorPalette, boolean isPaletteSorted, boolean isGifFrameInterlaced) {
        byte by2 = 0;
        if (colorPalette != null) {
            if (colorPalette.getEntriesCount() == 1) {
                throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
            }
            byte by3 = 0;
            int n2 = colorPalette.getEntriesCount();
            while (n2 > 2) {
                if ((n2 & 1) == 1) {
                    throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
                }
                n2 >>= 1;
                by3 = (byte)(by3 + 1);
            }
            by2 = (byte)(Operators.castToInt32(by2, 6) | Operators.castToInt32(by3, 6));
            by2 = (byte)(Operators.castToInt32(by2, 6) | 0x80);
        }
        if (isPaletteSorted) {
            by2 = (byte)(Operators.castToInt32(by2, 6) | 0x20);
        }
        if (isGifFrameInterlaced) {
            by2 = (byte)(Operators.castToInt32(by2, 6) | 0x40);
        }
        return by2;
    }

    static void saveGifFrameHeader(StreamContainer streamContainer, Rectangle blockRectangle, byte flags) {
        streamContainer.writeByte((byte)44);
        streamContainer.write(BitConverter.getBytesUInt16(Operators.castToUInt16(blockRectangle.getLeft(), 9)));
        streamContainer.write(BitConverter.getBytesUInt16(Operators.castToUInt16(blockRectangle.getTop(), 9)));
        streamContainer.write(BitConverter.getBytesUInt16(Operators.castToUInt16(blockRectangle.getWidth(), 9)));
        streamContainer.write(BitConverter.getBytesUInt16(Operators.castToUInt16(blockRectangle.getHeight(), 9)));
        streamContainer.writeByte(flags);
    }

    static void saveGif(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette palette, byte lzwCodeStartSize, boolean interlaced) {
        if (palette == null) {
            throw new ArgumentNullException("palette");
        }
        streamContainer.writeByte(lzwCodeStartSize);
        GifFrameBlock.a(rasterImage, streamContainer, palette, lzwCodeStartSize, interlaced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            GifFrameBlock.saveGifFrameHeader(streamContainer, new Rectangle(Operators.castToInt32(this.d, 8), Operators.castToInt32(this.e, 8), this.b, this.c), this.f);
            IColorPalette iColorPalette = this.getPalette();
            if (iColorPalette != null) {
                GifHelper.savePalette(streamContainer, iColorPalette);
            }
            GifFrameBlock.saveGif(this, streamContainer, this.a(), this.a, this.getInterlaced());
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.b = newWidth;
        this.c = newHeight;
    }

    @Override
    protected void onPaletteChanged(IColorPalette oldPalette, IColorPalette newPalette) {
        this.f = GifFrameBlock.createFlags(newPalette, (Operators.castToInt32(this.f, 6) & 0x20) > 0, (Operators.castToInt32(this.f, 6) & 0x40) > 0);
        super.onPaletteChanged(oldPalette, newPalette);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, byte by2, boolean bl2) {
        PartialEncoder partialEncoder = new PartialEncoder(rasterImage, streamContainer, iColorPalette, Operators.castToInt32(by2, 6), rasterImage.getWidth(), rasterImage.getHeight());
        try {
            if (bl2) {
                PartialProcessor.processInterlaced(rasterImage.getBounds().Clone(), rasterImage.getWidth(), rasterImage.getHeight(), partialEncoder);
            } else {
                PartialProcessor.process(rasterImage.getBounds().Clone(), partialEncoder);
            }
        }
        finally {
            if (partialEncoder != null) {
                partialEncoder.dispose();
            }
        }
    }

    private IColorPalette a() {
        IColorPalette iColorPalette = null;
        if (this.getContainer() != null) {
            iColorPalette = this.getContainer().getPalette();
        }
        return GifFrameBlock.getColorPalette(this.getPalette(), iColorPalette);
    }

    private void a(IColorPalette iColorPalette, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, byte by2) {
        this.f = GifFrameBlock.createFlags(iColorPalette, bl2, bl3);
        this.d = n2;
        this.e = n3;
        this.a = Operators.castToInt32(by2, 6) > 8 ? (byte)8 : (Operators.castToInt32(by2, 6) < 2 ? (byte)2 : by2);
        this.b = n4;
        this.c = n5;
    }

    private void a(RasterImagePixelLoader rasterImagePixelLoader, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        try {
            this.a(rasterImagePixelLoader.getRasterImage().getPalette(), n2, n3, rasterImagePixelLoader.getRasterImage().getWidth(), rasterImagePixelLoader.getRasterImage().getHeight(), bl2, bl3, by2);
            this.setPalette(rasterImagePixelLoader.getRasterImage().getPalette());
            this.setDataLoader(rasterImagePixelLoader);
        }
        catch (RuntimeException runtimeException) {
            rasterImagePixelLoader.dispose();
            throw runtimeException;
        }
    }

    private static class PartialEncoder
    extends DisposableObject
    implements IAdvancedBufferProcessor,
    IPartialArgb32PixelLoader,
    IPartialProcessor,
    IPartialRawDataLoader {
        private final StreamContainer a;
        private final IColorPalette b;
        private final RgbEntriesPaletteHash c;
        private final LzwVariableWidthBlockEncoder d;
        private final int e;
        private byte[] f = null;
        private final RasterImage g;
        private int h;
        private int i;

        public PartialEncoder(RasterImage frame, StreamContainer streamContainer, IColorPalette colorPalette, int lzwCodeStartSize, int width, int height) {
            this.g = frame;
            this.b = colorPalette;
            this.c = new RgbEntriesPaletteHash(colorPalette);
            this.a = new StreamContainer(streamContainer.getStream());
            this.a.seekBegin();
            this.d = new LzwVariableWidthBlockEncoder(this, lzwCodeStartSize);
            this.d.startEncoding();
            this.e = height;
            this.i = width * height;
            if (!this.a()) {
                this.f = BufferHelper.allocate(this.i);
            }
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            int n2 = msMath.min(this.f.length - this.h, pixels.length);
            int n3 = 0;
            do {
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n4 = pixels[n3++];
                    this.f[this.h++] = Operators.castToByte(this.c.getNearestColorIndex(n4), 9);
                }
                if (this.f.length - this.h != 0) continue;
                this.d.encode(this.f, this.h);
                this.h = 0;
            } while ((n2 = msMath.min(this.f.length - this.h, pixels.length - n3)) > 0);
            this.i -= pixels.length;
            if (this.i == 0) {
                this.d.encode(this.f, this.h);
                this.d.finishEncoding(this.e);
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] data, Point start, Point end) {
            this.d.encode(data, data.length);
            this.i -= data.length;
            if (this.i == 0) {
                this.d.finishEncoding(this.e);
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] data, Point start, Point end, LoadOptions loadOptions) {
            throw new NotImplementedException();
        }

        @Override
        public void processBuffer(byte[] buffer, int bufferLength) {
            this.a.write(buffer, 0, bufferLength);
        }

        @Override
        public void finishRow() {
        }

        @Override
        public void finishRows(int rowsCount) {
        }

        @Override
        public void process(Rectangle areaToProcess) {
            if (this.a()) {
                GifFrameBlockDataReader gifFrameBlockDataReader = (GifFrameBlockDataReader)((GifFrameBlock)this.g).getDataLoader();
                gifFrameBlockDataReader.loadRawData(areaToProcess.Clone(), this);
            } else {
                this.g.loadPartialArgb32Pixels(areaToProcess.Clone(), this);
            }
        }

        @Override
        protected void releaseManagedResources() {
            this.a.dispose();
            super.releaseManagedResources();
        }

        private boolean a() {
            boolean bl2 = Operators.is(this.g, GifFrameBlock.class) && Operators.is(Operators.as(this.g, GifFrameBlock.class).getDataLoader(), GifFrameBlockDataReader.class);
            return bl2;
        }
    }
}

