/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPaletteHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RgbEntriesPaletteHash;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering.FloydSteinbergDithering;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering.ThreshholdDithering;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;

public abstract class DitheringBase
implements IPartialArgb32PixelLoader {
    protected boolean SkipEmptyColor;
    protected final Rectangle DesiredRectangle;
    protected int ColorToSkip;
    protected int ColorToSkipArgb;
    protected int SubstituteColor;
    protected int SubstituteColorArgb;
    protected final IPartialArgb32PixelLoader FinalProcessor;
    protected final IColorPalette Palette;
    protected final RgbEntriesPaletteHash PaletteHash;
    private final int a;
    private final int b;

    protected DitheringBase(int width, int height, int bits, Rectangle desiredRectangle, IPartialArgb32PixelLoader finalProcessor, IColorPalette palette) {
        block6: {
            block5: {
                this.SkipEmptyColor = false;
                this.DesiredRectangle = new Rectangle();
                this.ColorToSkip = 0;
                this.ColorToSkipArgb = 0;
                this.SubstituteColorArgb = 0;
                this.FinalProcessor = finalProcessor;
                this.a = width;
                this.b = height;
                desiredRectangle.CloneTo(this.DesiredRectangle);
                if (palette != null) break block5;
                switch (bits) {
                    case 1: {
                        this.Palette = ColorPaletteHelper.createMonochrome();
                        break block6;
                    }
                    case 4: {
                        this.Palette = ColorPaletteHelper.create4BitGrayscale(false);
                        break block6;
                    }
                    case 8: {
                        this.Palette = ColorPaletteHelper.create8BitGrayscale(false);
                        break block6;
                    }
                    default: {
                        throw new ArgumentOutOfRangeException("bits");
                    }
                }
            }
            this.Palette = palette;
        }
        this.PaletteHash = new RgbEntriesPaletteHash(this.Palette);
    }

    protected DitheringBase(int width, int height, int bits, Rectangle desiredRectangle, IPartialArgb32PixelLoader finalProcessor, boolean skipEmptyColor, int colorToSkip, int substituteColor, IColorPalette palette) {
        this(width, height, bits, desiredRectangle.Clone(), finalProcessor, palette);
        this.SkipEmptyColor = skipEmptyColor;
        this.ColorToSkip = colorToSkip;
        this.ColorToSkipArgb = colorToSkip;
        this.SubstituteColor = substituteColor;
        this.SubstituteColorArgb = substituteColor;
    }

    public int getWidth() {
        return this.a;
    }

    public int getHeight() {
        return this.b;
    }

    public static DitheringBase getDithering(int ditheringMethod, int bits, IColorPalette customPalette, int width, int height, Rectangle desiredRectangle, IPartialArgb32PixelLoader finalProcessor, boolean skipEmptyColor, int colorToSkip, int substituteColor) {
        DitheringBase ditheringBase;
        switch (ditheringMethod) {
            case 0: {
                ditheringBase = new ThreshholdDithering(width, height, desiredRectangle.Clone(), bits, finalProcessor, skipEmptyColor, colorToSkip, substituteColor);
                break;
            }
            case 1: {
                ditheringBase = new FloydSteinbergDithering(width, height, desiredRectangle.Clone(), bits, customPalette, finalProcessor, skipEmptyColor, colorToSkip, substituteColor);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("ditheringMethod");
            }
        }
        return ditheringBase;
    }

    public static DitheringBase getDithering(int ditheringMethod, int bits, IColorPalette customPalette, int width, int height, Rectangle desiredRectangle, IPartialArgb32PixelLoader finalProcessor) {
        return DitheringBase.getDithering(ditheringMethod, bits, customPalette, width, height, desiredRectangle.Clone(), finalProcessor, false, 0, 0);
    }

    @Override
    public abstract void process(Rectangle var1, int[] var2, Point var3, Point var4);

    protected int switchColor(int newPixelArgb) {
        int n2 = newPixelArgb;
        if (this.SkipEmptyColor && newPixelArgb == this.ColorToSkipArgb) {
            n2 = this.SubstituteColorArgb;
        }
        return n2;
    }
}

