/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors;

import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.Adler;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.DeflateEncoder;
import com.aspose.html.internal.ms.lang.Operators;

final class ZlibEncoder {
    public byte[] InputBuffer;
    public int NextIn;
    public int AvailableBytesIn;
    public long TotalBytesIn;
    public byte[] OutputBuffer;
    public int NextOut;
    public int AvailableBytesOut;
    public long TotalBytesOut;
    DeflateEncoder deflateEncoder;
    private long a;
    private int b = 6;
    public int WindowBits = 15;
    public int Strategy = 0;

    public long getAdler32() {
        return this.a;
    }

    public void setAdler32(long value) {
        this.a = value;
    }

    public int getCompressLevel() {
        return this.b;
    }

    public void setCompressLevel(int value) {
        this.b = value;
    }

    public ZlibEncoder() {
        int n2 = this.a();
        if (n2 != 0) {
            throw new InvalidOperationException("CompressorException: Cannot initialize for deflate.");
        }
    }

    private int a() {
        return this.a(true);
    }

    public int initializeDeflate(int level) {
        this.setCompressLevel(level);
        return this.a(true);
    }

    public int initializeDeflate(int level, boolean wantRfc1950Header) {
        this.setCompressLevel(level);
        return this.a(wantRfc1950Header);
    }

    private int a(boolean bl2) {
        this.deflateEncoder = new DeflateEncoder();
        this.deflateEncoder.setWantRfc1950HeaderBytes(bl2);
        return this.deflateEncoder.initialize(this, this.getCompressLevel());
    }

    public int deflate(boolean flush) {
        if (this.deflateEncoder == null) {
            throw new InvalidOperationException("CompressorException: No Deflate State!");
        }
        return this.deflateEncoder.deflate(flush);
    }

    public int endDeflate() {
        if (this.deflateEncoder == null) {
            throw new InvalidOperationException("CompressorException: No Deflate State!");
        }
        int n2 = this.deflateEncoder.end();
        this.deflateEncoder = null;
        return n2;
    }

    public void resetDeflate() {
        if (this.deflateEncoder == null) {
            throw new InvalidOperationException("CompressorException: No Deflate State!");
        }
        this.deflateEncoder.reset();
    }

    void flushPending() {
        int n2 = this.deflateEncoder.PendingCount;
        if (n2 > this.AvailableBytesOut) {
            n2 = this.AvailableBytesOut;
        }
        if (n2 == 0) {
            return;
        }
        if (this.deflateEncoder.Pending.length <= this.deflateEncoder.NextPending || this.OutputBuffer.length <= this.NextOut || this.deflateEncoder.Pending.length < this.deflateEncoder.NextPending + n2 || this.OutputBuffer.length < this.NextOut + n2) {
            throw new InvalidOperationException(StringExtensions.format("CompressorException: Invalid State. (pending.Length={0}, pendingCount={1})", Operators.boxing(this.deflateEncoder.Pending.length), Operators.boxing(this.deflateEncoder.PendingCount)));
        }
        System.arraycopy(this.deflateEncoder.Pending, this.deflateEncoder.NextPending, this.OutputBuffer, this.NextOut, n2);
        this.NextOut += n2;
        this.deflateEncoder.NextPending += n2;
        this.TotalBytesOut += (long)n2;
        this.AvailableBytesOut -= n2;
        this.deflateEncoder.PendingCount -= n2;
        if (this.deflateEncoder.PendingCount == 0) {
            this.deflateEncoder.NextPending = 0;
        }
    }

    int read_buf(byte[] buf, int start, int size) {
        int n2 = this.AvailableBytesIn;
        if (n2 > size) {
            n2 = size;
        }
        if (n2 == 0) {
            return 0;
        }
        this.AvailableBytesIn -= n2;
        if (this.deflateEncoder.getWantRfc1950HeaderBytes()) {
            this.setAdler32(Adler.adler32(this.getAdler32() & 0xFFFFFFFFL, this.InputBuffer, this.NextIn, n2) & 0xFFFFFFFFL);
        }
        System.arraycopy(this.InputBuffer, this.NextIn, buf, start, n2);
        this.NextIn += n2;
        this.TotalBytesIn += (long)n2;
        return n2;
    }
}

