/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors;

import com.aspose.html.internal.ms.System.IO.EndOfStreamException;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.BufferReaderResult;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ValueResult;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.Adler;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.DeflateDecoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IBufferReader;
import com.aspose.html.internal.ms.lang.Operators;

public class ZlibDecoder {
    private static final int[] a = new int[]{256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
    private final IBufferReader b;
    private final boolean c;
    private StreamContainer d;
    private long e;
    private byte[] f = new byte[4];
    private DeflateDecoder g;
    private boolean h;
    private boolean i = true;

    public ZlibDecoder(IBufferReader bufferReader, boolean expectRfc1950Header) {
        this.b = bufferReader;
        this.c = expectRfc1950Header;
    }

    public boolean getPresetDictionaryFlag() {
        return this.h;
    }

    public boolean getIgnorePresetDictionaryFlag() {
        return this.i;
    }

    public void startInflate() {
    }

    public ValueResult inflate(byte[] outputBuffer, int bufferIndex, int bufferSize) {
        BufferReaderResult bufferReaderResult = this.b.readBuffer().Clone();
        if (bufferReaderResult.Result != 0) {
            ValueResult valueResult = new ValueResult();
            valueResult.Success = false;
            valueResult.ErrorMessage = bufferReaderResult.ErrorMessage;
            return valueResult;
        }
        this.d = new StreamContainer(new MemoryStream(bufferReaderResult.Buffer, 0, bufferReaderResult.BufferLength));
        this.g = new DeflateDecoder(this.d);
        this.g.startInflate();
        if (this.c) {
            return this.a(outputBuffer, bufferIndex, bufferSize);
        }
        return this.b(outputBuffer, bufferIndex, bufferSize);
    }

    private ValueResult a(byte[] byArray, int n2, int n3) {
        this.e = 1L;
        int n4 = this.d.read(this.f, 0, 2);
        if (n4 != 2) {
            throw new EndOfStreamException("Can't read the header bytes.");
        }
        int n5 = Operators.castToInt32(this.f[0], 6);
        byte by2 = Operators.castToByte(n5 & 0xF, 9);
        byte by3 = Operators.castToByte((n5 & 0xF0) >> 4, 9);
        int n6 = Operators.castToInt32(this.f[1], 6);
        byte by4 = Operators.castToByte((n6 & 0x10) >> 4, 9);
        int n7 = (n5 << 8 | n6) % 31;
        if (n7 != 0) {
            throw new InvalidOperationException("DeflateCompressorException: Check bits for CMF and FLG error");
        }
        boolean bl2 = this.h = Operators.castToInt32(by4, 6) > 0;
        if (this.h && !this.i) {
            throw new NotSupportedException("Preset dictionary not supported.");
        }
        ValueResult valueResult = new ValueResult();
        switch (Operators.castToInt32(by2, 6)) {
            case 8: {
                if (Operators.castToInt32(by3, 6) > 7) {
                    throw new InvalidOperationException("DeflateCompressorException: Window size value must be less than or equal to 7.");
                }
                int n8 = a[Operators.castToInt32(by3, 6)];
                int n9 = this.g.inflate(byArray, n2, n3 - n2);
                if (this.g.getSuccess()) {
                    boolean bl3;
                    this.e = Adler.adler32(this.e, byArray, n2, n9);
                    valueResult.Value = n9 - n2;
                    n4 = this.d.read(this.f, 0, 4);
                    if (n4 != 4) {
                        throw new EndOfStreamException("Can't read the Adler-32 checksum bytes.");
                    }
                    boolean bl4 = bl3 = Operators.castToUInt32(Operators.castToUInt32(this.e, 10) & 0xFFL, 10) == (long)Operators.castToInt32(this.f[3], 6) && Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(this.e, 10) >> 8, 10) & 0xFFL, 10) == (long)Operators.castToInt32(this.f[2], 6) && Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(this.e, 10) >> 16, 10) & 0xFFL, 10) == (long)Operators.castToInt32(this.f[1], 6) && Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(this.e, 10) >> 24, 10) & 0xFFL, 10) == (long)Operators.castToInt32(this.f[0], 6);
                    if (!bl3) {
                        throw new InvalidOperationException("DeflateCompressorException: Incorrect checksum.");
                    }
                    valueResult.Success = true;
                    break;
                }
                valueResult.Success = false;
                break;
            }
            case 15: {
                throw new NotSupportedException("CM (Compression method) = 15 is reserved.");
            }
            default: {
                throw new InvalidOperationException("DeflateCompressorException: Unknown compression method.");
            }
        }
        return valueResult;
    }

    private ValueResult b(byte[] byArray, int n2, int n3) {
        ValueResult valueResult = new ValueResult();
        valueResult.Value = this.g.inflate(byArray, n2, n3 - n2);
        valueResult.Success = true;
        return valueResult;
    }
}

