/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IIndexedColorConverter;

public class MapColorConverterDiffBits
extends ColorConverter {
    private static final int a = 256;
    protected final byte[] ConversionMap;
    private int b;
    private final int c;

    public MapColorConverterDiffBits(int width, int height, int lineSize, IColorPalette sourcePalette, PixelDataFormat sourcePixelFormat, Rectangle desiredRectangle, int destinationLineSize, IColorPalette destinationPalette, PixelDataFormat destPixelFormat, int ditheringMethod, IIndexedColorConverter indexedConverter, int fallbackIndex) {
        super(width, height, lineSize, sourcePixelFormat, desiredRectangle.Clone(), destPixelFormat, destinationLineSize);
        if (sourcePalette == null) {
            throw new ArgumentNullException("sourcePalette");
        }
        if (destinationPalette == null) {
            throw new ArgumentNullException("destinationPalette");
        }
        int n2 = (int)msMath.pow(2.0, this.SourcePixelSize);
        int n3 = 8 / this.SourcePixelSize;
        int n4 = n2 - 1;
        int n5 = (int)msMath.pow(2.0, this.DestinationPixelSize);
        int n6 = n5 - 1;
        int n7 = 8 / this.DestinationPixelSize;
        this.b = n3 / n7;
        int n8 = n7;
        if (this.b == 0) {
            this.b = 1;
            n8 = n3;
        }
        this.c = 8 / this.b;
        int n9 = 256 * this.b;
        this.ConversionMap = new byte[n9];
        if (ditheringMethod == 1) {
            int[] nArray = MapColorConverterDiffBits.correctPaletteEntries(sourcePalette, this.SourcePixelSize).getArgb32Entries();
            for (int i2 = 0; i2 < 256; ++i2) {
                int n10 = 8 - this.SourcePixelSize;
                int n11 = 0;
                int n12 = 0;
                while (n11 < n3) {
                    byte by2 = 0;
                    int n13 = 8 - this.DestinationPixelSize;
                    for (int i3 = 0; i3 < n8; ++i3) {
                        int n14 = i2 >> n10 & n4;
                        int n15 = nArray[n14];
                        int n16 = destinationPalette.getNearestColorIndex(n15);
                        if (n16 > n6) {
                            n16 = fallbackIndex;
                        }
                        by2 = (byte)(by2 & 0xFF | n16 << n13 & 0xFF);
                        n10 -= this.SourcePixelSize;
                        n13 -= this.DestinationPixelSize;
                    }
                    this.ConversionMap[i2 + n12] = by2;
                    n11 += n8;
                    n12 += 256;
                }
            }
        } else if (ditheringMethod == 0) {
            for (int i4 = 0; i4 < 256; ++i4) {
                int n17 = 8 - this.SourcePixelSize;
                int n18 = 0;
                int n19 = 0;
                while (n18 < n3) {
                    byte by3 = 0;
                    int n20 = 8 - this.DestinationPixelSize;
                    for (int i5 = 0; i5 < n8; ++i5) {
                        int n21;
                        int n22 = n21 = i4 >> n17 & n4;
                        if (n21 > n6) {
                            n22 = fallbackIndex;
                        }
                        by3 = (byte)(by3 & 0xFF | n22 << n20 & 0xFF);
                        n17 -= this.SourcePixelSize;
                        n20 -= this.DestinationPixelSize;
                    }
                    this.ConversionMap[i4 + n19] = by3;
                    n18 += n8;
                    n19 += 256;
                }
            }
        } else {
            byte[] byArray = MapColorConverterDiffBits.getConversionMap(indexedConverter, sourcePixelFormat, destPixelFormat, n2, n5);
            for (int i6 = 0; i6 < 256; ++i6) {
                int n23 = 8 - this.SourcePixelSize;
                int n24 = 0;
                int n25 = 0;
                while (n24 < n3) {
                    byte by4 = 0;
                    int n26 = 8 - this.DestinationPixelSize;
                    for (int i7 = 0; i7 < n8; ++i7) {
                        int n27 = i6 >> n23 & n4;
                        int n28 = byArray[n27] & 0xFF;
                        by4 = (byte)(by4 & 0xFF | n28 << n26 & 0xFF);
                        n23 -= this.SourcePixelSize;
                        n26 -= this.DestinationPixelSize;
                    }
                    this.ConversionMap[i6 + n25] = by4;
                    n24 += n8;
                    n25 += 256;
                }
            }
        }
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        int n2 = samplesCount * this.SourcePixelSize;
        int n3 = (bitStart + n2 - 1) / 8;
        int n4 = bitStart / 8;
        int n5 = n3 - n4 + 1;
        int n6 = bitStart * this.b / 8;
        int n7 = ((n2 + bitStart) * this.b - 1) / 8;
        int n8 = n7 - n6 + 1;
        int n9 = bitStart / this.c % this.b;
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n10 = offset + this.LineSize * i2;
            int n11 = i2 * destinationBytesPerLine + outputOffset;
            int n12 = n9 * 256;
            int n13 = 0;
            int n14 = n9;
            for (int i3 = 0; i3 < n5; ++i3) {
                byte by2 = data[n10++];
                int n15 = msMath.min(this.b, this.b - n14);
                n15 = msMath.min(n15, n8 - n13);
                for (int i4 = 0; i4 < n15; ++i4) {
                    byte by3 = this.ConversionMap[n12 + (by2 & 0xFF)];
                    outputData[n11 + n13++] = by3;
                    n12 += 256;
                }
                n12 = 0;
                n14 = 0;
            }
        }
    }
}

