/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

public abstract class IndexedToRgbConverter
extends ColorConverter {
    protected final int DestinationBytesCount;
    protected final int Ratio;
    protected final int SamplesPerByte;
    protected final int SourceMask;
    protected final IColorPalette SourcePalette;
    private byte[][] a;

    protected IndexedToRgbConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize, IColorPalette sourcePalette) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize);
        if (sourcePalette == null) {
            throw new ArgumentNullException("sourcePalette");
        }
        this.SourcePalette = sourcePalette;
        int n2 = (int)msMath.pow(2.0, this.SourcePixelSize);
        this.SourceMask = n2 - 1;
        this.SamplesPerByte = 8 / this.SourcePixelSize;
        this.Ratio = this.DestinationPixelSize / this.SourcePixelSize;
        this.DestinationBytesCount = this.DestinationPixelSize / 8;
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        if (this.a == null) {
            int[] nArray = IndexedToRgbConverter.correctPaletteEntries(this.SourcePalette, this.SourcePixelSize).getArgb32Entries();
            this.a = this.createMap(nArray);
        }
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = bitStart + samplesCount * this.SourcePixelSize;
            int n3 = (n2 - 1) / 8;
            int n4 = bitStart / 8;
            int n5 = n3 - n4 + 1;
            int n6 = bitStart;
            int n7 = bitStart % 8 / this.SourcePixelSize * this.DestinationBytesCount;
            int n8 = 0;
            for (int i3 = 0; i3 < n5; ++i3) {
                byte[] byArray = this.a[data[i3 + this.LineSize * i2 + offset] & 0xFF];
                int n9 = (n6 + 8) / 8 * 8;
                n9 = msMath.min(n9, n2);
                int n10 = (n9 - n6) / this.SourcePixelSize;
                int n11 = n10 * this.DestinationBytesCount;
                System.arraycopy(byArray, n7, outputData, outputOffset + n8, n11);
                n6 += n10 * this.SourcePixelSize;
                n7 = 0;
                n8 += n11;
            }
            outputOffset += destinationBytesPerLine;
        }
    }

    protected abstract byte[][] createMap(int[] var1);
}

