/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;

public class CmykToRgba32PngConverter
extends ColorConverter {
    public CmykToRgba32PngConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize);
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = offset + this.LineSize * i2;
            int n3 = i2 * destinationBytesPerLine + outputOffset;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                int n4 = i3 * this.SourceFormat.getChannelsCount() + n2;
                double d2 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                double d3 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                double d4 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                double d5 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                outputData[n3++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d2) * (1.0 - d5)));
                outputData[n3++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d3) * (1.0 - d5)));
                outputData[n3++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d4) * (1.0 - d5)));
                outputData[n3++] = -1;
            }
        }
    }
}

