/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;

public class CmykToRgb16Converter
extends ColorConverter {
    private static final int a = 31;
    private static final int b = 4;

    public CmykToRgb16Converter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize);
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = offset + this.LineSize * i2;
            int n3 = i2 * destinationBytesPerLine + outputOffset;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                int n4 = i3 * 4 + n2;
                double d2 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                double d3 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                double d4 = 1.0 - (double)(data[n4++] & 0xFF) / 255.0;
                double d5 = 1.0 - (double)(data[n4] & 0xFF) / 255.0;
                byte by2 = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d2) * (1.0 - d5)));
                byte by3 = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d3) * (1.0 - d5)));
                byte by4 = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d4) * (1.0 - d5)));
                int n5 = 0x1F & (int)((double)(by4 & 0xFF) / 8.225806451612904 + 0.5) | (0x1F & (int)((double)(by3 & 0xFF) / 8.225806451612904 + 0.5)) << 5 | (0x1F & (int)((double)(by2 & 0xFF) / 8.225806451612904 + 0.5)) << 10;
                outputData[n3++] = (byte)(n5 & 0xFF);
                outputData[n3++] = (byte)((n5 & 0xFF00) >> 8);
            }
        }
    }
}

