/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.CMYKColor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.CMYKHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Image;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering.DitheringBase;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering.DitheringMode;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IIndexedColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialPixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public abstract class RasterImage
extends Image
implements IRasterImageArgb32PixelLoader {
    private DitheringMode a;
    private IRasterImageArgb32PixelLoader b = new RasterImageEmptyLoader(this);
    private int c;
    private IIndexedColorConverter d;
    private IColorConverter e;
    private int f;

    protected RasterImage() {
    }

    protected RasterImage(IColorPalette colorPalette) {
        super(colorPalette);
    }

    @Deprecated
    public int getRawDitheringMethod() {
        return this.c;
    }

    @Deprecated
    public void setRawDitheringMethod(int value) {
        this.c = value;
    }

    public IIndexedColorConverter getRawIndexedColorConverter() {
        return this.d;
    }

    public void setRawIndexedColorConverter(IIndexedColorConverter value) {
        this.d = value;
    }

    public IColorConverter getRawCustomColorConverter() {
        return this.e;
    }

    public void setRawCustomColorConverter(IColorConverter value) {
        this.e = value;
    }

    public int getRawFallbackIndex() {
        return this.f;
    }

    public void setRawFallbackIndex(int value) {
        this.f = value;
    }

    @Override
    public RawDataSettings getRawDataSettings() {
        RawDataSettings rawDataSettings = this.b.getRawDataSettings();
        rawDataSettings.setIndexedColorConverter(this.d);
        rawDataSettings.setFallbackIndex(this.f);
        rawDataSettings.setDitheringMethod(this.c);
        rawDataSettings.setCustomColorConverter(this.e);
        return rawDataSettings;
    }

    public PixelDataFormat getRawDataFormat() {
        return PixelDataFormat.getRgbIndexed1Bpp();
    }

    public int getRawLineSize() {
        return 0;
    }

    @Override
    public boolean isRawDataAvailable() {
        this.verifyNotDisposed();
        return this.b.isRawDataAvailable();
    }

    public double getHorizontalResolution() {
        return 96.0;
    }

    public void setHorizontalResolution(double value) {
    }

    public double getVerticalResolution() {
        return 96.0;
    }

    public void setVerticalResolution(double value) {
    }

    @Deprecated
    public DitheringMode getDitheringSettings() {
        return this.a;
    }

    @Deprecated
    public void setDitheringSettings(DitheringMode value) {
        this.a = value;
    }

    public boolean hasTransparentColor() {
        return false;
    }

    public void setTransparentColor(boolean value) {
    }

    public int getTransparentColor() {
        return 0;
    }

    public void setTransparentColor(int value) {
    }

    public IRasterImageArgb32PixelLoader getDataLoader() {
        return this.b;
    }

    public void setDataLoader(IRasterImageArgb32PixelLoader value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value != this.b) {
            IDisposable iDisposable = Operators.as(this.b, IDisposable.class);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.b = value;
        }
    }

    public void getDefaultPixels(Rectangle rectangle, IPartialArgb32PixelLoader partialPixelLoader) {
        PartialDefaultPixelLoader partialDefaultPixelLoader = new PartialDefaultPixelLoader(this, partialPixelLoader);
        PartialProcessor.process(rectangle.Clone(), partialDefaultPixelLoader);
    }

    public void getDefaultRawData(Rectangle rectangle, IPartialRawDataLoader partialRawDataLoader, RawDataSettings rawDataSettings) {
        PartialDefaultRawDataLoader partialDefaultRawDataLoader = new PartialDefaultRawDataLoader(this, partialRawDataLoader, rawDataSettings);
        PartialProcessor.process(rectangle.Clone(), partialDefaultRawDataLoader);
    }

    public int[] getDefaultArgb32Pixels(Rectangle rectangle) {
        int[] nArray;
        int n2 = 0;
        if (this.getPalette() != null) {
            n2 = this.getPalette().getArgb32Color(0);
        }
        try {
            nArray = new int[(int)(Operators.castToInt64(rectangle.getWidth(), 9) * (long)rectangle.getHeight())];
        }
        catch (OverflowException overflowException) {
            throw new OutOfMemoryException();
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = n2;
        }
        return nArray;
    }

    public byte[] getDefaultRawData(Rectangle rectangle, RawDataSettings rawDataSettings) {
        byte[] byArray;
        long l2;
        if (rawDataSettings == null) {
            throw new ArgumentNullException("rawDataSettings");
        }
        int n2 = rectangle.getLeft();
        int n3 = rectangle.getRight();
        if (n2 == 0 && n3 == this.getWidth()) {
            l2 = rawDataSettings.getLineSize();
        } else {
            int n4 = rawDataSettings.getPixelDataFormat().getBitsPerPixel();
            int n5 = n4 * n2 / 8;
            int n6 = (n4 * n3 + 7) / 8;
            l2 = n6 - n5;
        }
        long l3 = rectangle.getHeight();
        long l4 = l2 * l3;
        try {
            byArray = new byte[(int)l4];
        }
        catch (OverflowException overflowException) {
            throw new OutOfMemoryException();
        }
        return byArray;
    }

    public int getArgb32Pixel(int x2, int y2) {
        this.verifyNotDisposed();
        Rectangle rectangle = new Rectangle(x2, y2, 1, 1);
        StandardLoadPixelsPartialProcessor standardLoadPixelsPartialProcessor = new StandardLoadPixelsPartialProcessor(rectangle.Clone());
        this.a(rectangle.Clone(), true, standardLoadPixelsPartialProcessor);
        if (standardLoadPixelsPartialProcessor.getPixels() == null || standardLoadPixelsPartialProcessor.getPixels().length == 0) {
            throw new FrameworkException("Cannot get pixel in evaluation mode. Please set license first.");
        }
        return standardLoadPixelsPartialProcessor.getPixels()[0];
    }

    public int getPixel(int x2, int y2) {
        return this.getArgb32Pixel(x2, y2);
    }

    public void setArgb32Pixel(int x2, int y2, int argb32Color) {
        this.verifyNotDisposed();
        this.a(new Rectangle(x2, y2, 1, 1), new int[]{argb32Color}, true);
    }

    public void setPixel(int x2, int y2, int color) {
        this.setArgb32Pixel(x2, y2, color);
    }

    public int[] readScanLine(int scanLineIndex) {
        this.verifyNotDisposed();
        Rectangle rectangle = new Rectangle(0, scanLineIndex, this.getWidth(), 1);
        StandardLoadPixelsPartialProcessor standardLoadPixelsPartialProcessor = new StandardLoadPixelsPartialProcessor(rectangle.Clone());
        this.a(rectangle.Clone(), true, standardLoadPixelsPartialProcessor);
        return standardLoadPixelsPartialProcessor.getPixels();
    }

    public void writeScanLine(int scanLineIndex, int[] pixels) {
        this.verifyNotDisposed();
        this.a(new Rectangle(0, scanLineIndex, this.getWidth(), 1), pixels, true);
    }

    @Override
    public void loadPartialArgb32Pixels(Rectangle desiredRectangle, IPartialArgb32PixelLoader pixelLoader) {
        this.verifyNotDisposed();
        this.a(desiredRectangle.Clone(), true, pixelLoader);
    }

    public void loadPartialPixels(Rectangle desiredRectangle, IPartialPixelLoader pixelLoader) {
        this.verifyNotDisposed();
        this.a(desiredRectangle.Clone(), true, new PartialLoaderWrapper(pixelLoader));
    }

    public int[] loadArgb32Pixels(Rectangle rectangle) {
        this.verifyNotDisposed();
        StandardLoadPixelsPartialProcessor standardLoadPixelsPartialProcessor = new StandardLoadPixelsPartialProcessor(rectangle.Clone());
        this.a(rectangle.Clone(), true, standardLoadPixelsPartialProcessor);
        return standardLoadPixelsPartialProcessor.getPixels();
    }

    public int[] loadPixels(Rectangle rectangle) {
        return this.loadArgb32Pixels(rectangle.Clone());
    }

    public CMYKColor[] loadCMYKPixels(Rectangle rectangle) {
        this.verifyNotDisposed();
        StandardLoadPixelsPartialProcessor standardLoadPixelsPartialProcessor = new StandardLoadPixelsPartialProcessor(rectangle.Clone());
        this.a(rectangle.Clone(), true, standardLoadPixelsPartialProcessor);
        int[] nArray = standardLoadPixelsPartialProcessor.getPixels();
        CMYKColor[] cMYKColorArray = null;
        if (nArray != null) {
            cMYKColorArray = CMYKHelper.toCMYK(nArray);
        }
        return cMYKColorArray;
    }

    @Override
    public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader rawDataLoader) {
        this.verifyNotDisposed();
        this.a(rectangle.Clone(), true, rawDataSettings, rawDataLoader);
    }

    public void saveRawData(byte[] data, int dataOffset, Rectangle rectangle, RawDataSettings rawDataSettings) {
        throw new NotImplementedException();
    }

    public void saveArgb32Pixels(Rectangle rectangle, int[] pixels) {
        this.verifyNotDisposed();
        this.a(rectangle.Clone(), pixels, true);
    }

    public void savePixels(Rectangle rectangle, int[] pixels) {
        this.saveArgb32Pixels(rectangle.Clone(), pixels);
    }

    public void saveCMYKPixels(Rectangle rectangle, CMYKColor[] pixels) {
        this.saveArgb32Pixels(rectangle.Clone(), CMYKHelper.toColor(pixels));
    }

    public void setResolution(double dpiX, double dpiY) {
    }

    @Override
    public void setPalette(IColorPalette palette, boolean updateColors) {
        if (updateColors) {
            Rectangle rectangle = this.getBounds().Clone();
            int[] nArray = this.loadArgb32Pixels(rectangle.Clone());
            this.setPalette(palette);
            this.saveArgb32Pixels(rectangle.Clone(), nArray);
        } else {
            this.setPalette(palette);
        }
    }

    @Override
    public void resize(int newWidth, int newHeight, int resizeType) {
        throw new NotImplementedException();
    }

    public void crop(Rectangle rectangle) {
        throw new NotImplementedException();
    }

    public void binarizeFixed(byte threshold) {
        throw new NotImplementedException();
    }

    public void binarizeOtsu() {
        throw new NotImplementedException();
    }

    public void grayscale() {
        throw new NotImplementedException();
    }

    public void adjustBrightness(int brightness) {
        throw new NotImplementedException();
    }

    public void adjustContrast(float contrast) {
        throw new NotImplementedException();
    }

    public void adjustGamma(float gammaRed, float gammaGreen, float gammaBlue) {
        throw new NotImplementedException();
    }

    public void adjustGamma(float gamma) {
        throw new NotImplementedException();
    }

    public void crop(int leftShift, int rightShift, int topShift, int bottomShift) {
        this.crop(new Rectangle(leftShift, topShift, this.getWidth() - leftShift - rightShift, this.getHeight() - topShift - bottomShift));
    }

    public void rotate(float angle, boolean resizeProportionally, int backgroundColor) {
        throw new NotImplementedException();
    }

    public void rotate(float angle) {
        this.rotate(angle, true, 0);
    }

    protected void loadPixelsInternal(Rectangle rectangle, IPartialArgb32PixelLoader pixelLoader) {
        PartialPixelLoader partialPixelLoader = new PartialPixelLoader(this.b, pixelLoader);
        PartialProcessor.process(rectangle.Clone(), partialPixelLoader);
    }

    protected abstract void savePixelsInternal(Rectangle var1, int[] var2);

    @Override
    protected void releaseManagedResources() {
        IDisposable iDisposable = Operators.as(this.b, IDisposable.class);
        if (iDisposable != null) {
            iDisposable.dispose();
        }
        this.b = null;
        super.releaseManagedResources();
    }

    private int[] a(Rectangle rectangle, boolean bl2, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        this.verifyNotDisposed();
        this.getFitRectangle(rectangle.Clone()).CloneTo(rectangle);
        if (this.a != null) {
            DitheringBase ditheringBase = DitheringBase.getDithering(this.a.getMethod(), this.a.getBits(), this.a.getCustomPalette(), this.getWidth(), this.getHeight(), rectangle.Clone(), iPartialArgb32PixelLoader);
            iPartialArgb32PixelLoader = ditheringBase;
            this.getBounds().CloneTo(rectangle);
        }
        return this.a(rectangle.Clone(), null, bl2, iPartialArgb32PixelLoader);
    }

    private void a(Rectangle rectangle, int[] nArray, boolean bl2) {
        this.verifyNotDisposed();
        this.getFitRectangle(rectangle.Clone(), nArray).CloneTo(rectangle);
        this.savePixelsInternal(rectangle.Clone(), nArray);
    }

    private int[] a(Rectangle rectangle, int[] nArray, boolean bl2, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        int[] nArray2 = null;
        this.loadPixelsInternal(rectangle.Clone(), iPartialArgb32PixelLoader);
        return nArray2;
    }

    private byte[] a(Rectangle rectangle, boolean bl2, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
        this.verifyNotDisposed();
        this.getFitRectangle(rectangle.Clone()).CloneTo(rectangle);
        byte[] byArray = new byte[8];
        this.a(rectangle.Clone(), byArray, bl2, rawDataSettings, iPartialRawDataLoader);
        return byArray;
    }

    private byte[] a(Rectangle rectangle, byte[] byArray, boolean bl2, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
        byte[] byArray2 = null;
        this.b.loadRawData(rectangle.Clone(), rawDataSettings, iPartialRawDataLoader);
        return byArray2;
    }

    private static class PartialLoaderWrapper
    implements IPartialArgb32PixelLoader {
        private final IPartialPixelLoader a;

        public PartialLoaderWrapper(IPartialPixelLoader partialPixelLoader) {
            this.a = partialPixelLoader;
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            this.a.process(pixelsRectangle.Clone(), pixels, start.Clone(), end.Clone());
        }
    }

    private static class ValidRawDataLoader
    implements IPartialRawDataLoader {
        private IPartialRawDataLoader a;
        private RasterImage b;
        private RawDataSettings c;

        public ValidRawDataLoader(RasterImage rasterImage, RawDataSettings rawDataSettings, IPartialRawDataLoader loader) {
            this.a = loader;
            this.b = rasterImage;
            this.c = rawDataSettings;
        }

        @Override
        public void process(Rectangle rectangle, byte[] data, Point start, Point end) {
            this.a.process(rectangle.Clone(), data, start.Clone(), end.Clone());
        }

        @Override
        public void process(Rectangle rectangle, byte[] data, Point start, Point end, LoadOptions loadOptions) {
            throw new NotImplementedException();
        }
    }

    private static class StandardLoadPixelsPartialProcessor
    implements IPartialArgb32PixelLoader {
        private int[] a;
        private Rectangle b = new Rectangle();

        public StandardLoadPixelsPartialProcessor(Rectangle desiredArea) {
            desiredArea.CloneTo(this.b);
        }

        public int[] getPixels() {
            return this.a;
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            if (pixelsRectangle.equals(Operators.boxing(this.b))) {
                this.a = pixels;
            } else {
                Rectangle rectangle = Rectangle.intersect(this.b.Clone(), pixelsRectangle.Clone()).Clone();
                if (rectangle.getWidth() > 0 && rectangle.getHeight() > 0) {
                    if (this.a == null) {
                        try {
                            this.a = new int[(int)(Operators.castToInt64(this.b.getWidth(), 9) * (long)this.b.getHeight())];
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new FrameworkException("Cannot allocate so many bytes. Use LoadPartialPixels instead.");
                        }
                        catch (OverflowException overflowException) {
                            throw new FrameworkException("Cannot allocate so many bytes. Use LoadPartialPixels instead.");
                        }
                    }
                    if (pixelsRectangle.getLeft() == this.b.getLeft() && pixelsRectangle.getRight() == this.b.getRight()) {
                        int n2 = 0;
                        int n3 = (pixelsRectangle.getTop() - this.b.getTop()) * this.b.getWidth();
                        if (n3 < 0) {
                            n2 = n3 * -1;
                            n3 = 0;
                        }
                        System.arraycopy(pixels, n2, this.a, n3, rectangle.getWidth() * rectangle.getHeight());
                    } else {
                        int n4;
                        int n5 = 0;
                        int n6 = pixelsRectangle.getTop() - this.b.getTop();
                        if (n6 < 0) {
                            n5 = (this.b.getTop() - pixelsRectangle.getTop()) * pixelsRectangle.getWidth();
                            n6 = 0;
                        }
                        if ((n4 = pixelsRectangle.getLeft() - this.b.getLeft()) < 0) {
                            n5 += n4 * -1;
                            n4 = 0;
                        }
                        for (int i2 = 0; i2 < rectangle.getHeight(); ++i2) {
                            int n7 = n5 + i2 * pixelsRectangle.getWidth();
                            int n8 = n6++ * this.b.getWidth() + n4;
                            System.arraycopy(pixels, n7, this.a, n8, rectangle.getWidth());
                        }
                    }
                }
            }
        }
    }

    private static class ValidPixelsLoader
    implements IPartialArgb32PixelLoader {
        private IPartialArgb32PixelLoader a;
        private RasterImage b;

        public ValidPixelsLoader(RasterImage rasterImage, IPartialArgb32PixelLoader loader) {
            this.a = loader;
            this.b = rasterImage;
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            this.a.process(pixelsRectangle.Clone(), pixels, start.Clone(), end.Clone());
        }
    }

    private static class RasterImageFullWatermarkDrawer
    implements IPartialArgb32PixelLoader {
        private final RasterImage a;

        public RasterImageFullWatermarkDrawer(RasterImage rasterImage) {
            this.a = rasterImage;
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            this.a.savePixelsInternal(pixelsRectangle.Clone(), pixels);
        }
    }

    private static class PartialDefaultRawDataLoader
    implements IPartialProcessor {
        private final IPartialRawDataLoader a;
        private final RasterImage b;
        private final RawDataSettings c;

        public PartialDefaultRawDataLoader(RasterImage image, IPartialRawDataLoader partialRawDataLoader, RawDataSettings rawDataSettings) {
            this.b = image;
            this.a = partialRawDataLoader;
            this.c = rawDataSettings;
        }

        @Override
        public void process(Rectangle areaToProcess) {
            byte[] byArray = this.b.getDefaultRawData(areaToProcess.Clone(), this.c);
            this.a.process(areaToProcess.Clone(), byArray, areaToProcess.getLocation().Clone(), new Point(areaToProcess.getRight(), areaToProcess.getBottom()));
        }
    }

    private static class PartialDefaultPixelLoader
    implements IPartialProcessor {
        private final IPartialArgb32PixelLoader a;
        private final RasterImage b;

        public PartialDefaultPixelLoader(RasterImage image, IPartialArgb32PixelLoader partialPixelLoader) {
            this.b = image;
            this.a = partialPixelLoader;
        }

        @Override
        public void process(Rectangle areaToProcess) {
            int[] nArray = this.b.getDefaultArgb32Pixels(areaToProcess.Clone());
            this.a.process(areaToProcess.Clone(), nArray, areaToProcess.getLocation().Clone(), new Point(areaToProcess.getRight(), areaToProcess.getBottom()));
        }
    }

    private static class RasterImageEmptyLoader
    implements IRasterImageArgb32PixelLoader {
        private final RasterImage a;

        public RasterImageEmptyLoader(RasterImage image) {
            this.a = image;
        }

        @Override
        public boolean isRawDataAvailable() {
            return true;
        }

        @Override
        public RawDataSettings getRawDataSettings() {
            RawDataSettings rawDataSettings = new RawDataSettings();
            rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgb32Bpp());
            rawDataSettings.setLineSize(this.a.getWidth() * 4);
            return rawDataSettings;
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader partialLoader) {
            this.a.getDefaultPixels(rectangle.Clone(), partialLoader);
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader rawDataLoader) {
            this.a.getDefaultRawData(rectangle.Clone(), rawDataLoader, rawDataSettings);
        }
    }

    private static class PartialPixelLoader
    implements IPartialProcessor {
        private final IRasterImageArgb32PixelLoader a;
        private final IPartialArgb32PixelLoader b;

        public PartialPixelLoader(IRasterImageArgb32PixelLoader pixelLoader, IPartialArgb32PixelLoader pixelProcessor) {
            this.a = pixelLoader;
            this.b = pixelProcessor;
        }

        @Override
        public void process(Rectangle areaToProcess) {
            this.a.loadPartialArgb32Pixels(areaToProcess.Clone(), this.b);
        }
    }
}

