/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import java.awt.Color;

public class ColorHelper {
    private static int a;

    public static int getMaxAllowedAllocation() {
        return a;
    }

    public static void setMaxAllowedAllocation(int value) {
        a = value;
    }

    public static ColorInfo allocate(Rectangle rectangle) {
        int[] nArray = null;
        int n2 = 2;
        while (nArray == null) {
            try {
                int n3 = rectangle.getWidth() * rectangle.getHeight();
                if (ColorHelper.getMaxAllowedAllocation() > 0 && n3 > ColorHelper.getMaxAllowedAllocation()) {
                    throw new OutOfMemoryException();
                }
                nArray = ArrayHelper.getColors(n3);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (rectangle.getHeight() > 1) {
                    rectangle.setHeight(rectangle.getHeight() / n2);
                    if (rectangle.getHeight() <= 1) {
                        rectangle.setHeight(1);
                        n2 = 1;
                    }
                } else if (rectangle.getWidth() > 1) {
                    rectangle.setWidth(rectangle.getWidth() / n2);
                    if (rectangle.getWidth() < 1) {
                        rectangle.setWidth(1);
                    }
                } else {
                    throw outOfMemoryError;
                }
                n2 <<= 1;
            }
        }
        return new ColorInfo(rectangle.Clone(), nArray);
    }

    public static Color newColor(Color c2) {
        return new Color(c2.getRGB(), true);
    }

    public static Color fromArgb(int a2, int r2, int g2, int b2) {
        return new Color(r2, g2, b2, a2);
    }

    public static Color fromArgb(int r2, int g2, int b2) {
        return new Color(r2, g2, b2, 255);
    }

    public static Color fromArgb(int argb) {
        return ColorHelper.fromArgb(argb >>> 24 & 0xFF, argb >>> 16 & 0xFF, argb >>> 8 & 0xFF, argb & 0xFF);
    }

    public static int toArgb(Color c2) {
        return c2.getRGB();
    }

    public static int toArgb(int a2, int r2, int g2, int b2) {
        return (a2 & 0xFF) << 24 | (r2 & 0xFF) << 16 | (g2 & 0xFF) << 8 | (b2 & 0xFF) << 0;
    }

    public static int toArgb(int r2, int g2, int b2) {
        return ColorHelper.toArgb(255, r2, g2, b2);
    }

    public static byte getA(int argb) {
        return (byte)(argb >>> 24 & 0xFF);
    }

    public static byte getR(int argb) {
        return (byte)(argb >>> 16 & 0xFF);
    }

    public static byte getG(int argb) {
        return (byte)(argb >>> 8 & 0xFF);
    }

    public static byte getB(int argb) {
        return (byte)(argb >>> 0 & 0xFF);
    }
}

