/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.BitConverter;

public class ByteConverter {
    public static byte[] getBigEndianBytesSingle(float value) {
        byte[] byArray = BitConverter.getBytesSingle(value);
        byte[] byArray2 = new byte[]{byArray[3], byArray[2], byArray[1], byArray[0]};
        return byArray2;
    }

    public static byte[] getBigEndianBytesDouble(double value) {
        byte[] byArray = BitConverter.getBytesDouble(value);
        byte[] byArray2 = new byte[]{byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]};
        return byArray2;
    }

    public static byte[] getBigEndianBytesUInt64(long value) {
        byte[] byArray = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)value};
        return byArray;
    }

    public static byte[] getBigEndianBytesInt64(long value) {
        byte[] byArray = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)value};
        return byArray;
    }

    public static byte[] getBigEndianBytesInt32(int value) {
        byte[] byArray = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)value};
        return byArray;
    }

    public static byte[] getBigEndianBytesUInt32(long value) {
        byte[] byArray = new byte[]{(byte)((value & 0xFFFFFFFFL) >> 24 & 0xFFL), (byte)((value & 0xFFFFFFFFL) >> 16 & 0xFFL), (byte)((value & 0xFFFFFFFFL) >> 8 & 0xFFL), (byte)(value & 0xFFFFFFFFL)};
        return byArray;
    }

    public static byte[] getBigEndianBytesInt16(short value) {
        byte[] byArray = new byte[]{(byte)(value >> 8), (byte)value};
        return byArray;
    }

    public static byte[] getBigEndianBytesUInt16(int value) {
        byte[] byArray = new byte[]{(byte)((value & 0xFFFF) >> 8), (byte)(value & 0xFFFF)};
        return byArray;
    }

    public static void writeBigEndianBytesUInt64(long value, byte[] bytes, int index) {
        bytes[index] = (byte)(value >> 56 & 0xFFL);
        bytes[index + 1] = (byte)(value >> 48 & 0xFFL);
        bytes[index + 2] = (byte)(value >> 40 & 0xFFL);
        bytes[index + 3] = (byte)(value >> 32 & 0xFFL);
        bytes[index + 4] = (byte)(value >> 24 & 0xFFL);
        bytes[index + 5] = (byte)(value >> 16 & 0xFFL);
        bytes[index + 6] = (byte)(value >> 8 & 0xFFL);
        bytes[index + 7] = (byte)value;
    }

    public static void writeBigEndianBytesInt64(long value, byte[] bytes, int index) {
        bytes[index] = (byte)(value >> 56 & 0xFFL);
        bytes[index + 1] = (byte)(value >> 48 & 0xFFL);
        bytes[index + 2] = (byte)(value >> 40 & 0xFFL);
        bytes[index + 3] = (byte)(value >> 32 & 0xFFL);
        bytes[index + 4] = (byte)(value >> 24 & 0xFFL);
        bytes[index + 5] = (byte)(value >> 16 & 0xFFL);
        bytes[index + 6] = (byte)(value >> 8 & 0xFFL);
        bytes[index + 7] = (byte)value;
    }

    public static void writeBigEndianBytesInt32(int value, byte[] bytes, int index) {
        bytes[index] = (byte)(value >> 24 & 0xFF);
        bytes[index + 1] = (byte)(value >> 16 & 0xFF);
        bytes[index + 2] = (byte)(value >> 8 & 0xFF);
        bytes[index + 3] = (byte)value;
    }

    public static void writeBigEndianBytesUInt32(long value, byte[] bytes, int index) {
        bytes[index] = (byte)((value & 0xFFFFFFFFL) >> 24 & 0xFFL);
        bytes[index + 1] = (byte)((value & 0xFFFFFFFFL) >> 16 & 0xFFL);
        bytes[index + 2] = (byte)((value & 0xFFFFFFFFL) >> 8 & 0xFFL);
        bytes[index + 3] = (byte)(value & 0xFFFFFFFFL);
    }

    public static void writeBigEndianBytesSingle(float value, byte[] bytes, int index) {
        byte[] byArray = BitConverter.getBytesSingle(value);
        bytes[index] = byArray[3];
        bytes[index + 1] = byArray[2];
        bytes[index + 2] = byArray[1];
        bytes[index + 3] = byArray[0];
    }

    public static void writeBigEndianBytesDouble(double value, byte[] bytes, int index) {
        byte[] byArray = BitConverter.getBytesDouble(value);
        bytes[index + 0] = byArray[7];
        bytes[index + 1] = byArray[6];
        bytes[index + 2] = byArray[5];
        bytes[index + 3] = byArray[4];
        bytes[index + 4] = byArray[3];
        bytes[index + 5] = byArray[2];
        bytes[index + 6] = byArray[1];
        bytes[index + 7] = byArray[0];
    }

    public static void writeBigEndianBytesInt16(short value, byte[] bytes, int index) {
        bytes[index] = (byte)(value >> 8);
        bytes[index + 1] = (byte)value;
    }

    public static void writeBigEndianBytesUInt16(int value, byte[] bytes, int index) {
        bytes[index] = (byte)((value & 0xFFFF) >> 8);
        bytes[index + 1] = (byte)(value & 0xFFFF);
    }

    public static long fromBigEndianToInt64(byte[] bytes, int index) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (index < 0 || index + 8 > bytes.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (long)(bytes[index] & 0xFF) << 56 | (long)(bytes[index + 1] & 0xFF) << 48 | (long)(bytes[index + 2] & 0xFF) << 40 | (long)(bytes[index + 3] & 0xFF) << 32 | (long)(bytes[index + 4] & 0xFF) << 24 | (long)(bytes[index + 5] & 0xFF) << 16 | (long)(bytes[index + 6] & 0xFF) << 8 | (long)(bytes[index + 7] & 0xFF);
    }

    public static long fromBigEndianToUInt64(byte[] bytes, int index) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (index < 0 || index + 8 > bytes.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (long)(bytes[index] & 0xFF) << 56 | (long)(bytes[index + 1] & 0xFF) << 48 | (long)(bytes[index + 2] & 0xFF) << 40 | (long)(bytes[index + 3] & 0xFF) << 32 | (long)(bytes[index + 4] & 0xFF) << 24 | (long)(bytes[index + 5] & 0xFF) << 16 | (long)(bytes[index + 6] & 0xFF) << 8 | (long)(bytes[index + 7] & 0xFF);
    }

    public static int fromBigEndianToInt32(byte[] bytes, int index) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (index < 0 || index + 4 > bytes.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (bytes[index] & 0xFF) << 24 | (bytes[index + 1] & 0xFF) << 16 | (bytes[index + 2] & 0xFF) << 8 | bytes[index + 3] & 0xFF;
    }

    public static float fromBigEndianToSingle(byte[] bytes, int index) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (index < 0 || index + 4 > bytes.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        byte[] byArray = new byte[]{bytes[index + 3], bytes[index + 2], bytes[index + 1], bytes[index + 0]};
        return BitConverter.toSingle(byArray, 0);
    }

    public static double fromBigEndianToDouble(byte[] bytes, int index) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (index < 0 || index + 4 > bytes.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        byte[] byArray = new byte[]{bytes[index + 7], bytes[index + 6], bytes[index + 5], bytes[index + 4], bytes[index + 3], bytes[index + 2], bytes[index + 1], bytes[index + 0]};
        return BitConverter.toDouble(byArray, 0);
    }

    public static long fromBigEndianToUInt32(byte[] bytes, int index) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (index < 0 || index + 4 > bytes.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (long)((bytes[index] & 0xFF) << 24 | (bytes[index + 1] & 0xFF) << 16 | (bytes[index + 2] & 0xFF) << 8 | bytes[index + 3] & 0xFF) & 0xFFFFFFFFL;
    }

    public static short fromBigEndianToInt16(byte[] bytes, int index) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (index < 0 || index + 2 > bytes.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (short)((bytes[index] & 0xFF) << 8 | bytes[index + 1] & 0xFF);
    }

    public static int fromBigEndianToUInt16(byte[] bytes, int index) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        if (index < 0 || index + 2 > bytes.length) {
            throw new ArgumentOutOfRangeException("index", "The index falls outside the bytes array.");
        }
        return (bytes[index] & 0xFF) << 8 | bytes[index + 1] & 0xFF;
    }
}

