/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.drawing.Color;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.lang.Operators;

public class Argb32Helper {
    public static final int Empty = 0;
    private static final int a = 24;
    private static final int b = 16;
    private static final int c = 8;
    private static final int d = 0;
    private static final int e = Color.getWhite().toArgb();
    private static final int f = Color.getBlack().toArgb();

    public static int getWhiteArgb() {
        return e;
    }

    public static int getBlackArgb() {
        return f;
    }

    public static Color[] convert(int[] argbColors) {
        if (argbColors == null) {
            return null;
        }
        Color[] colorArray = new Color[argbColors.length];
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            Color.fromArgb(argbColors[i2]).CloneTo(colorArray[i2]);
        }
        return colorArray;
    }

    public static int[] convert(Color[] colors) {
        if (colors == null) {
            return null;
        }
        int[] nArray = new int[colors.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = colors[i2].toArgb();
        }
        return nArray;
    }

    public static int fromArgb(int red, int green, int blue) {
        return Argb32Helper.fromArgb(255, red, green, blue);
    }

    public static int fromArgb(int alpha, int red, int green, int blue) {
        Argb32Helper.a(alpha, "alpha");
        Argb32Helper.a(red, "red");
        Argb32Helper.a(green, "green");
        Argb32Helper.a(blue, "blue");
        return Argb32Helper.a(Operators.castToInt32(Operators.castToByte(alpha, 9), 6), Operators.castToInt32(Operators.castToByte(red, 9), 6), Operators.castToInt32(Operators.castToByte(green, 9), 6), Operators.castToInt32(Operators.castToByte(blue, 9), 6));
    }

    private static int a(int n2, int n3, int n4, int n5) {
        return n2 << 24 | n3 << 16 | n4 << 8 | n5 << 0;
    }

    private static void a(int n2, String string) {
        if (n2 < 0 || n2 > 255) {
            throw new ArgumentOutOfRangeException(string);
        }
    }
}

