/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.Printing;

import com.aspose.html.internal.ms.System.ArgumentException;
import java.util.Locale;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.PrinterName;

public class PrinterUtils {
    public static String[] getInstalledPrinters() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        if (printServiceArray == null || printServiceArray.length == 0) {
            return null;
        }
        int n2 = printServiceArray.length;
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = printServiceArray[i2].getName();
        }
        return stringArray;
    }

    public static String getDefaultPrinter() {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        return printService == null ? null : printService.getName();
    }

    public static PrintService find(String printer) {
        try {
            HashAttributeSet hashAttributeSet = new HashAttributeSet();
            hashAttributeSet.add(new PrinterName(printer, Locale.getDefault()));
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, hashAttributeSet);
            if (printServiceArray.length == 0) {
                printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
                if (printServiceArray == null || printServiceArray.length == 0) {
                    return null;
                }
                for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
                    if (!printServiceArray[i2].getName().equals(printer)) continue;
                    return printServiceArray[i2];
                }
                return null;
            }
            return printServiceArray[0];
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static boolean isPrinterValid(String printer) {
        return PrinterUtils.find(printer) != null;
    }

    public static int getMaximumCopies(CopiesSupported copiesSupported) {
        int[][] nArray = copiesSupported.getMembers();
        if (nArray.length != 1 && nArray[0].length != 2) {
            throw new ArgumentException("Invalid CopiesSupported value");
        }
        return nArray[0][1];
    }
}

