/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.XmlIgnoreAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAny;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObject;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObjectCollection;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaParticle;

public abstract class XmlSchemaGroupBase
extends XmlSchemaParticle {
    private XmlSchemaObjectCollection a = new XmlSchemaObjectCollection();

    protected XmlSchemaGroupBase() {
    }

    @XmlIgnoreAttribute
    public abstract XmlSchemaObjectCollection getItems();

    XmlSchemaObjectCollection getCompiledItems() {
        return this.a;
    }

    void copyOptimizedItems(XmlSchemaGroupBase gb2) {
        for (int i2 = 0; i2 < this.getItems().size(); ++i2) {
            XmlSchemaObject xmlSchemaObject = this.getItems().get_Item(i2);
            XmlSchemaParticle xmlSchemaParticle = xmlSchemaObject instanceof XmlSchemaParticle ? (XmlSchemaParticle)xmlSchemaObject : null;
            if ((xmlSchemaParticle = xmlSchemaParticle.getOptimizedParticle(false)) == XmlSchemaParticle.getEmpty()) continue;
            gb2.getItems().add(xmlSchemaParticle);
            gb2.getCompiledItems().add(xmlSchemaParticle);
        }
    }

    @Override
    boolean particleEquals(XmlSchemaParticle other) {
        XmlSchemaGroupBase xmlSchemaGroupBase;
        XmlSchemaGroupBase xmlSchemaGroupBase2 = xmlSchemaGroupBase = other instanceof XmlSchemaGroupBase ? (XmlSchemaGroupBase)other : null;
        if (xmlSchemaGroupBase == null) {
            return false;
        }
        if (ObjectExtensions.getType(this) != ObjectExtensions.getType(xmlSchemaGroupBase)) {
            return false;
        }
        if (Decimal.op_Inequality(this.getValidatedMaxOccurs(), xmlSchemaGroupBase.getValidatedMaxOccurs()) || Decimal.op_Inequality(this.getValidatedMinOccurs(), xmlSchemaGroupBase.getValidatedMinOccurs())) {
            return false;
        }
        if (this.getCompiledItems().size() != xmlSchemaGroupBase.getCompiledItems().size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getCompiledItems().size(); ++i2) {
            XmlSchemaParticle xmlSchemaParticle;
            XmlSchemaObject xmlSchemaObject = this.getCompiledItems().get_Item(i2);
            XmlSchemaObject xmlSchemaObject2 = xmlSchemaGroupBase.getCompiledItems().get_Item(i2);
            XmlSchemaParticle xmlSchemaParticle2 = xmlSchemaObject instanceof XmlSchemaParticle ? (XmlSchemaParticle)xmlSchemaObject : null;
            XmlSchemaParticle xmlSchemaParticle3 = xmlSchemaParticle = xmlSchemaObject2 instanceof XmlSchemaParticle ? (XmlSchemaParticle)xmlSchemaObject2 : null;
            if (xmlSchemaParticle2.particleEquals(xmlSchemaParticle)) continue;
            return false;
        }
        return true;
    }

    @Override
    void checkRecursion(int depth, ValidationEventHandler h2, XmlSchema schema) {
        for (XmlSchemaParticle xmlSchemaParticle : this.getItems()) {
            xmlSchemaParticle.checkRecursion(depth, h2, schema);
        }
    }

    boolean validateNSRecurseCheckCardinality(XmlSchemaAny any, ValidationEventHandler h2, XmlSchema schema, boolean raiseError) {
        for (XmlSchemaParticle xmlSchemaParticle : this.getItems()) {
            if (xmlSchemaParticle.validateDerivationByRestriction(any, h2, schema, raiseError)) continue;
            return false;
        }
        return this.validateOccurenceRangeOK(any, h2, schema, raiseError);
    }

    boolean validateRecurse(XmlSchemaGroupBase baseGroup, ValidationEventHandler h2, XmlSchema schema, boolean raiseError) {
        return this.validateSeqRecurseMapSumCommon(baseGroup, h2, schema, false, false, raiseError);
    }

    boolean validateSeqRecurseMapSumCommon(XmlSchemaGroupBase baseGroup, ValidationEventHandler h2, XmlSchema schema, boolean isLax, boolean isMapAndSum, boolean raiseError) {
        XmlSchemaParticle xmlSchemaParticle;
        XmlSchemaObject xmlSchemaObject;
        int n2;
        int n3 = 0;
        int n4 = 0;
        Decimal decimal = Decimal.newDecimalFromInt(0);
        if (baseGroup.getCompiledItems().size() == 0 && this.getCompiledItems().size() > 0) {
            if (raiseError) {
                this.error(h2, "Invalid particle derivation by restriction was found. base particle does not contain particles.");
            }
            return false;
        }
        block0: for (n2 = 0; n2 < this.getCompiledItems().size(); ++n2) {
            xmlSchemaObject = null;
            while (this.getCompiledItems().size() > n3 && (xmlSchemaObject = (XmlSchemaParticle)this.getCompiledItems().get_Item(n3)) == XmlSchemaParticle.getEmpty()) {
                ++n3;
            }
            if (n3 >= this.getCompiledItems().size()) {
                if (raiseError) {
                    this.error(h2, "Invalid particle derivation by restriction was found. Cannot be mapped to base particle.");
                }
                return false;
            }
            xmlSchemaParticle = null;
            while (baseGroup.getCompiledItems().size() > n4) {
                xmlSchemaParticle = (XmlSchemaParticle)baseGroup.getCompiledItems().get_Item(n4);
                if (xmlSchemaParticle == XmlSchemaParticle.getEmpty() && Decimal.op_GreaterThan(xmlSchemaParticle.getValidatedMaxOccurs(), Decimal.newDecimalFromInt(0))) continue;
                if (!((XmlSchemaParticle)xmlSchemaObject).validateDerivationByRestriction(xmlSchemaParticle, h2, schema, false)) {
                    if (!isLax && !isMapAndSum && Decimal.op_GreaterThan(xmlSchemaParticle.getMinOccurs(), decimal) && !xmlSchemaParticle.validateIsEmptiable()) {
                        if (raiseError) {
                            this.error(h2, "Invalid particle derivation by restriction was found. Invalid sub-particle derivation was found.");
                        }
                        return false;
                    }
                    decimal = Decimal.newDecimalFromInt(0);
                    ++n4;
                    continue;
                }
                if (Decimal.op_GreaterThanOrEqual(decimal = Decimal.op_Addition(decimal, xmlSchemaParticle.getValidatedMinOccurs()), baseGroup.getValidatedMaxOccurs())) {
                    decimal = Decimal.newDecimalFromInt(0);
                    ++n4;
                }
                ++n3;
                continue block0;
            }
        }
        if (this.getCompiledItems().size() > 0 && n3 != this.getCompiledItems().size()) {
            if (raiseError) {
                this.error(h2, "Invalid particle derivation by restriction was found. Extraneous derived particle was found.");
            }
            return false;
        }
        if (!isLax && !isMapAndSum) {
            if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromInt(0))) {
                ++n4;
            }
            for (n2 = n4; n2 < baseGroup.getCompiledItems().size(); ++n2) {
                xmlSchemaObject = baseGroup.getCompiledItems().get_Item(n2);
                XmlSchemaObject xmlSchemaObject2 = xmlSchemaParticle = xmlSchemaObject instanceof XmlSchemaParticle ? xmlSchemaObject : null;
                if (xmlSchemaParticle.validateIsEmptiable()) continue;
                if (raiseError) {
                    this.error(h2, "Invalid particle derivation by restriction was found. There is a base particle which does not have mapped derived particle and is not emptiable.");
                }
                return false;
            }
        }
        return true;
    }
}

