/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.DTDAttributeDefinition;
import com.aspose.html.internal.ms.System.Xml.XmlAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlNode;

public class XmlNamedNodeMap
implements IEnumerable {
    static IEnumerator emptyEnumerator = Array.boxing(new XmlNode[0]).iterator();
    private XmlNode a;
    private ArrayList b;
    private boolean c = false;

    XmlNamedNodeMap(XmlNode parent) {
        this.a = parent;
    }

    private ArrayList a() {
        if (this.b == null) {
            this.b = new ArrayList();
        }
        return this.b;
    }

    public int size() {
        return this.b == null ? 0 : this.b.size();
    }

    public IEnumerator iterator() {
        if (this.b == null) {
            return emptyEnumerator;
        }
        return this.b.iterator();
    }

    public XmlNode getNamedItem(String name) {
        if (this.b == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            XmlNode xmlNode = (XmlNode)this.b.get_Item(i2);
            if (StringExtensions.equals(xmlNode.getName(), name)) {
                return xmlNode;
            }
            if (!StringExtensions.equals(xmlNode.getLocalName(), name)) continue;
            return xmlNode;
        }
        return null;
    }

    public XmlNode getNamedItem(String localName, String namespaceURI) {
        if (this.b == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            XmlNode xmlNode = (XmlNode)this.b.get_Item(i2);
            if (!StringExtensions.equals(xmlNode.getLocalName(), localName) || !StringExtensions.equals(xmlNode.getNamespaceURI(), namespaceURI)) continue;
            return xmlNode;
        }
        return null;
    }

    public XmlNode item(int index) {
        if (this.b == null || index < 0 || index >= this.b.size()) {
            return null;
        }
        return (XmlNode)this.b.get_Item(index);
    }

    public XmlNode removeNamedItem(String name) {
        if (this.b == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            DTDAttributeDefinition dTDAttributeDefinition;
            XmlAttribute xmlAttribute;
            XmlNode xmlNode = (XmlNode)this.b.get_Item(i2);
            if (!StringExtensions.equals(xmlNode.getName(), name)) continue;
            if (xmlNode.isReadOnly()) {
                throw new InvalidOperationException(StringExtensions.concat("Cannot remove. This node is read only: ", name));
            }
            this.b.removeItem(xmlNode);
            XmlAttribute xmlAttribute2 = xmlAttribute = xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
            if (xmlAttribute != null && (dTDAttributeDefinition = xmlAttribute.getAttributeDefinition()) != null && dTDAttributeDefinition.getDefaultValue() != null) {
                XmlAttribute xmlAttribute3 = xmlAttribute.getOwnerDocument().createAttribute(xmlAttribute.getPrefix(), xmlAttribute.getLocalName(), xmlAttribute.getNamespaceURI(), true, false);
                xmlAttribute3.setValue(dTDAttributeDefinition.getDefaultValue());
                xmlAttribute3.setDefault();
                xmlAttribute.getOwnerElement().setAttributeNode(xmlAttribute3);
            }
            return xmlNode;
        }
        return null;
    }

    public XmlNode removeNamedItem(String localName, String namespaceURI) {
        if (this.b == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            XmlNode xmlNode = (XmlNode)this.b.get_Item(i2);
            if (!StringExtensions.equals(xmlNode.getLocalName(), localName) || !StringExtensions.equals(xmlNode.getNamespaceURI(), namespaceURI)) continue;
            this.b.removeItem(xmlNode);
            return xmlNode;
        }
        return null;
    }

    public XmlNode setNamedItem(XmlNode node) {
        return this.setNamedItem(node, -1, true);
    }

    XmlNode setNamedItem(XmlNode node, boolean raiseEvent) {
        return this.setNamedItem(node, -1, raiseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlNode setNamedItem(XmlNode node, int pos, boolean raiseEvent) {
        if (this.c || node.getOwnerDocument() != this.a.getOwnerDocument()) {
            throw new ArgumentException("Cannot add to NodeMap.");
        }
        if (raiseEvent) {
            this.a.getOwnerDocument().onNodeInserting(node, this.a);
        }
        try {
            for (int i2 = 0; i2 < this.a().size(); ++i2) {
                XmlNode xmlNode = (XmlNode)this.b.get_Item(i2);
                if (!StringExtensions.equals(xmlNode.getLocalName(), node.getLocalName()) || !StringExtensions.equals(xmlNode.getNamespaceURI(), node.getNamespaceURI())) continue;
                this.b.removeItem(xmlNode);
                if (pos < 0) {
                    this.b.addItem(node);
                } else {
                    this.b.insertItem(pos, node);
                }
                XmlNode xmlNode2 = xmlNode;
                return xmlNode2;
            }
            if (pos < 0) {
                this.b.addItem(node);
            } else {
                this.b.insertItem(pos, node);
            }
            XmlNode xmlNode = node;
            return xmlNode;
        }
        finally {
            if (raiseEvent) {
                this.a.getOwnerDocument().onNodeInserted(node, this.a);
            }
        }
    }

    ArrayList getNodes() {
        return this.a();
    }
}

