/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.SystemException;
import com.aspose.html.internal.ms.System.Xml.IXmlLineInfo;

@SerializableAttribute
public class XmlException
extends SystemException {
    private int a;
    private int b;
    private String c;
    private String d;
    private String[] e;
    private static final String f = "An XML error has occurred";
    private static final String g = "{0}";

    public XmlException() {
        this.d = f;
        this.e = new String[1];
    }

    public XmlException(String message, Exception innerException) {
        super(message, innerException);
        this.d = g;
        this.e = new String[]{message};
    }

    public XmlException(String message) {
        super(message);
        this.d = g;
        this.e = new String[]{message};
    }

    public XmlException(IXmlLineInfo li, String sourceUri, String message) {
        this(li, null, sourceUri, message);
    }

    public XmlException(IXmlLineInfo li, Exception innerException, String sourceUri, String message) {
        this(message, innerException);
        if (li != null) {
            this.a = li.getLineNumber();
            this.b = li.getLinePosition();
        }
        this.c = sourceUri;
    }

    public XmlException(String message, Exception innerException, int lineNumber, int linePosition) {
        this(message, innerException);
        this.a = lineNumber;
        this.b = linePosition;
    }

    public int getLineNumber() {
        return this.a;
    }

    public int getLinePosition() {
        return this.b;
    }

    public String getSourceUri() {
        return this.c;
    }

    @Override
    public String getMessage() {
        if (this.a == 0) {
            return super.getMessage();
        }
        return StringExtensions.format(CultureInfo.getInvariantCulture(), "{0} {3} Line {1}, position {2}.", super.getMessage(), this.a, this.b, this.c);
    }
}

