/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.IFormattable;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Xml.TypeData;
import com.aspose.html.internal.ms.System.Xml.XmlConvert;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

class XmlCustomFormatter {
    private static final StringSwitchMap a = new StringSwitchMap("boolean", "unsignedByte", "char", "dateTime", "date", "time", "decimal", "double", "short", "int", "long", "byte", "float", "unsignedShort", "unsignedInt", "unsignedLong", "guid", "base64", "base64Binary", "hexBinary", "duration", "NMTOKEN", "Name", "NCName", "language", "ENTITY", "ID", "IDREF", "NOTATION", "token", "normalizedString", "string", "base64:");

    XmlCustomFormatter() {
    }

    static String fromByteArrayBase64(byte[] value) {
        return value == null ? StringExtensions.Empty : Convert.toBase64String(value);
    }

    static String fromByteArrayHex(byte[] value) {
        if (value == null) {
            return null;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (byte by2 : value) {
            msStringBuilder2.append(ByteExtensions.toString(by2, "X2", CultureInfo.getInvariantCulture()));
        }
        return msStringBuilder2.toString();
    }

    static String fromChar(char value) {
        return Int32Extensions.toString(Operators.castToInt32(Character.valueOf(value), 4), CultureInfo.getInvariantCulture());
    }

    static String fromDate(DateTime value) {
        return XmlConvert.toString_DateTime(value.Clone(), "yyyy-MM-dd");
    }

    static String fromDateTime(DateTime value) {
        return XmlConvert.toString_DateTime(value.Clone(), 3);
    }

    static String fromTime(DateTime value) {
        return XmlConvert.toString_DateTime(value.Clone(), "HH:mm:ss.fffffffzzz");
    }

    static String fromEnum(long value, String[] values, long[] ids) {
        return XmlCustomFormatter.fromEnum(value, values, ids, null);
    }

    static String fromEnum(long value, String[] values, long[] ids, String typeName) {
        if (ids == null || values == null) {
            throw new NullReferenceException();
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        int n2 = ids.length;
        long l2 = value;
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (ids[i2] == 0L) {
                n3 = i2;
                continue;
            }
            if (l2 == 0L) break;
            if ((ids[i2] & value) != ids[i2]) continue;
            if (msStringBuilder2.getLength() != 0) {
                msStringBuilder2.append(' ');
            }
            msStringBuilder2.append(values[i2]);
            l2 &= ids[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (l2 != 0L) {
            if (typeName != null) {
                throw new InvalidOperationException(StringExtensions.format(CultureInfo.getCurrentCulture(), "'{0}' is not a valid value for {1}.", value, typeName));
            }
            throw new InvalidOperationException(StringExtensions.format(CultureInfo.getCurrentCulture(), "'{0}' is not a valid value.", value));
        }
        if (msStringBuilder2.getLength() == 0 && n3 != -1) {
            msStringBuilder2.append(values[n3]);
        }
        return msStringBuilder2.toString();
    }

    static String fromXmlName(String name) {
        return XmlConvert.encodeName(name);
    }

    static String fromXmlNCName(String ncName) {
        return XmlConvert.encodeLocalName(ncName);
    }

    static String fromXmlNmToken(String nmToken) {
        return XmlConvert.encodeNmToken(nmToken);
    }

    static String fromXmlNmTokens(String nmTokens) {
        String[] stringArray = StringExtensions.split(nmTokens, ' ');
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = XmlCustomFormatter.fromXmlNmToken(stringArray[i2]);
        }
        return StringExtensions.join(" ", stringArray);
    }

    static byte[] toByteArrayBase64(String value) {
        return Convert.fromBase64String(value);
    }

    static char toChar(String value) {
        return Operators.castToChar(XmlConvert.toUInt16(value), 8);
    }

    static DateTime toDate(String value) {
        return XmlCustomFormatter.toDateTime(value);
    }

    static DateTime toDateTime(String value) {
        return XmlConvert.toDateTime(value, 3);
    }

    static DateTime toTime(String value) {
        return XmlCustomFormatter.toDateTime(value);
    }

    static long toEnum(String value, Hashtable values, String typeName, boolean validate) {
        String[] stringArray;
        if (values == null) {
            throw new NullReferenceException();
        }
        long l2 = 0L;
        for (String string : stringArray = StringExtensions.split(value, ' ')) {
            Object object = values.get_Item(string);
            if (object != null) {
                l2 |= Operators.unboxing(object, Long.TYPE).longValue();
                continue;
            }
            if (!validate || string.length() == 0) continue;
            throw new InvalidOperationException(StringExtensions.format("'{0}' is not a valid member of type {1}.", string, typeName));
        }
        return l2;
    }

    static String toXmlName(String value) {
        return XmlConvert.decodeName(value);
    }

    static String toXmlNCName(String value) {
        return XmlCustomFormatter.toXmlName(value);
    }

    static String toXmlNmToken(String value) {
        return XmlCustomFormatter.toXmlName(value);
    }

    static String toXmlNmTokens(String value) {
        return XmlCustomFormatter.toXmlName(value);
    }

    static String toXmlString(TypeData type, Object value) {
        if (value == null) {
            return null;
        }
        if (Operators.typeOf(value.getClass()).isEnum()) {
            return Enum.format(Operators.typeOf(value.getClass()), value, "g");
        }
        switch (a.of(type.getXmlType())) {
            case 0: {
                return XmlConvert.toString_Bool(Operators.unboxing(value, Boolean.TYPE));
            }
            case 1: {
                return XmlConvert.toString_Byte(Operators.unboxing(value, Byte.TYPE));
            }
            case 2: {
                return XmlConvert.toString_Int32(Operators.castToInt32((Character)value, 4));
            }
            case 3: {
                return XmlConvert.toString_DateTime(Operators.unboxing(value, DateTime.class).Clone(), 3);
            }
            case 4: {
                return Operators.unboxing(value, DateTime.class).toString("yyyy-MM-dd", CultureInfo.getInvariantCulture());
            }
            case 5: {
                return Operators.unboxing(value, DateTime.class).toString("HH:mm:ss.FFFFFFF", CultureInfo.getInvariantCulture());
            }
            case 6: {
                return XmlConvert.toString_Decimal(Operators.unboxing(value, Decimal.class).Clone());
            }
            case 7: {
                return XmlConvert.toString_Double(Operators.unboxing(value, Double.TYPE));
            }
            case 8: {
                return XmlConvert.toString_Int16(Operators.unboxing(value, Short.TYPE));
            }
            case 9: {
                return XmlConvert.toString_Int32(Operators.unboxing(value, Integer.TYPE));
            }
            case 10: {
                return XmlConvert.toString_Int64(Operators.unboxing(value, Long.TYPE));
            }
            case 11: {
                return XmlConvert.toString_SByte(Operators.unboxing(value, Byte.TYPE));
            }
            case 12: {
                return XmlConvert.toString_Float(Operators.unboxing(value, Float.TYPE).floatValue());
            }
            case 13: {
                return XmlConvert.toString_UInt16(Operators.unboxing(value, Integer.TYPE));
            }
            case 14: {
                return XmlConvert.toString_UInt32(Operators.unboxing(value, Long.TYPE));
            }
            case 15: {
                return XmlConvert.toString_UInt64(Operators.unboxing(value, Long.TYPE));
            }
            case 16: {
                return XmlConvert.toString_Guid(Operators.unboxing(value, Guid.class).Clone());
            }
            case 17: 
            case 18: {
                return value == null ? StringExtensions.Empty : Convert.toBase64String(Operators.cast(value, byte[].class));
            }
            case 19: {
                return value == null ? StringExtensions.Empty : XmlConvert.toBinHexString(Operators.cast(value, byte[].class));
            }
            case 20: {
                return (String)value;
            }
        }
        return Operators.is(value, IFormattable.class) ? ((IFormattable)value).toString(null, CultureInfo.getInvariantCulture()) : value.toString();
    }

    static Object fromXmlString(TypeData type, String value) {
        if (value == null) {
            return null;
        }
        switch (a.of(type.getXmlType())) {
            case 0: {
                return XmlConvert.toBoolean(value);
            }
            case 1: {
                return XmlConvert.toByte(value);
            }
            case 2: {
                return Character.valueOf((char)XmlConvert.toInt32(value));
            }
            case 3: {
                return XmlConvert.toDateTime(value, 3);
            }
            case 4: {
                return DateTime.parseExact(value, "yyyy-MM-dd", null);
            }
            case 5: {
                return DateTime.parseExact(value, "HH:mm:ss.FFFFFFF", null);
            }
            case 6: {
                return XmlConvert.toDecimal(value);
            }
            case 7: {
                return XmlConvert.toDouble(value);
            }
            case 8: {
                return XmlConvert.toInt16(value);
            }
            case 9: {
                return XmlConvert.toInt32(value);
            }
            case 10: {
                return XmlConvert.toInt64(value);
            }
            case 11: {
                return XmlConvert.toSByte(value);
            }
            case 12: {
                return Float.valueOf(XmlConvert.toSingle(value));
            }
            case 13: {
                return XmlConvert.toUInt16(value);
            }
            case 14: {
                return XmlConvert.toUInt32(value);
            }
            case 15: {
                return XmlConvert.toUInt64(value);
            }
            case 16: {
                return XmlConvert.toGuid(value);
            }
            case 17: 
            case 18: {
                return Convert.fromBase64String(value);
            }
            case 19: {
                return XmlConvert.fromBinHexString(value);
            }
            case 20: {
                return value;
            }
        }
        if (type.getType() != null) {
            return Convert.changeType((Object)value, type.getType(), null);
        }
        return value;
    }

    static String generateToXmlString(TypeData type, String value) {
        if (type.getNullableOverride()) {
            return StringExtensions.concat("(", value, " != null ? ", XmlCustomFormatter.generateToXmlStringCore(type, value), " : null)");
        }
        return XmlCustomFormatter.generateToXmlStringCore(type, value);
    }

    static String generateToXmlStringCore(TypeData type, String value) {
        if (type.getNullableOverride()) {
            value = StringExtensions.concat(value, ".Value");
        }
        switch (a.of(type.getXmlType())) {
            case 0: {
                return StringExtensions.concat("(", value, "?\"true\":\"false\")");
            }
            case 1: {
                return StringExtensions.concat(value, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 2: {
                return StringExtensions.concat("((int)(", value, ")).ToString(CultureInfo.InvariantCulture)");
            }
            case 3: {
                return StringExtensions.concat("XmlConvert.ToString (", value, ", XmlDateTimeSerializationMode.RoundtripKind)");
            }
            case 4: {
                return StringExtensions.concat(value, ".ToString(\"yyyy-MM-dd\", CultureInfo.InvariantCulture)");
            }
            case 5: {
                return StringExtensions.concat(value, ".ToString(\"HH:mm:ss.FFFFFFF\", CultureInfo.InvariantCulture)");
            }
            case 6: {
                return StringExtensions.concat("XmlConvert.ToString (", value, ")");
            }
            case 7: {
                return StringExtensions.concat("XmlConvert.ToString (", value, ")");
            }
            case 8: {
                return StringExtensions.concat(value, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 9: {
                return StringExtensions.concat(value, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 10: {
                return StringExtensions.concat(value, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 11: {
                return StringExtensions.concat(value, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 12: {
                return StringExtensions.concat("XmlConvert.ToString (", value, ")");
            }
            case 13: {
                return StringExtensions.concat(value, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 14: {
                return StringExtensions.concat(value, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 15: {
                return StringExtensions.concat(value, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 16: {
                return StringExtensions.concat("XmlConvert.ToString (", value, ")");
            }
            case 17: 
            case 18: {
                return StringExtensions.concat(value, " == null ? String.Empty : Convert.ToBase64String (", value, ")");
            }
            case 19: {
                return StringExtensions.concat(value, " == null ? String.Empty : ToBinHexString (", value, ")");
            }
            case 20: {
                return value;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return value;
            }
        }
        return StringExtensions.concat("((", value, " != null) ? (", value, ").ToString() : null)");
    }

    static String generateFromXmlString(TypeData type, String value) {
        if (type.getNullableOverride()) {
            return StringExtensions.concat("(", value, " != null ? (", type.getCSharpName(), "?)", XmlCustomFormatter.generateFromXmlStringCore(type, value), " : null)");
        }
        return XmlCustomFormatter.generateFromXmlStringCore(type, value);
    }

    static String generateFromXmlStringCore(TypeData type, String value) {
        switch (a.of(type.getXmlType())) {
            case 0: {
                return StringExtensions.concat("XmlConvert.ToBoolean (", value, ")");
            }
            case 1: {
                return StringExtensions.concat("byte.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 2: {
                return StringExtensions.concat("(char)Int32.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 3: {
                return StringExtensions.concat("XmlConvert.ToDateTime (", value, ", XmlDateTimeSerializationMode.RoundtripKind)");
            }
            case 4: {
                return StringExtensions.concat("DateTime.ParseExact (", value, ", \"yyyy-MM-dd\", CultureInfo.InvariantCulture)");
            }
            case 5: {
                return StringExtensions.concat("DateTime.ParseExact (", value, ", \"HH:mm:ss.FFFFFFF\", CultureInfo.InvariantCulture)");
            }
            case 6: {
                return StringExtensions.concat("Decimal.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 7: {
                return StringExtensions.concat("XmlConvert.ToDouble (", value, ")");
            }
            case 8: {
                return StringExtensions.concat("Int16.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 9: {
                return StringExtensions.concat("Int32.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 10: {
                return StringExtensions.concat("Int64.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 11: {
                return StringExtensions.concat("SByte.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 12: {
                return StringExtensions.concat("XmlConvert.ToSingle (", value, ")");
            }
            case 13: {
                return StringExtensions.concat("UInt16.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 14: {
                return StringExtensions.concat("UInt32.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 15: {
                return StringExtensions.concat("UInt64.Parse (", value, ", CultureInfo.InvariantCulture)");
            }
            case 16: {
                return StringExtensions.concat("XmlConvert.ToGuid (", value, ")");
            }
            case 18: 
            case 32: {
                return StringExtensions.concat("Convert.FromBase64String (", value, ")");
            }
            case 19: {
                return StringExtensions.concat("FromBinHexString (", value, ")");
            }
            case 20: {
                return value;
            }
        }
        return value;
    }
}

