/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.Collections.Stack;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Security.Policy.Evidence;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.System.Xml.CompiledExpression;
import com.aspose.html.internal.ms.System.Xml.CompiledStylesheet;
import com.aspose.html.internal.ms.System.Xml.ExprKeyContainer;
import com.aspose.html.internal.ms.System.Xml.Expression;
import com.aspose.html.internal.ms.System.Xml.FunctionArguments;
import com.aspose.html.internal.ms.System.Xml.IStaticXsltContext;
import com.aspose.html.internal.ms.System.Xml.IXmlLineInfo;
import com.aspose.html.internal.ms.System.Xml.MSXslNodeSet;
import com.aspose.html.internal.ms.System.Xml.MSXslScriptManager;
import com.aspose.html.internal.ms.System.Xml.NameTable;
import com.aspose.html.internal.ms.System.Xml.Pattern;
import com.aspose.html.internal.ms.System.Xml.VariableScope;
import com.aspose.html.internal.ms.System.Xml.XPathDocument;
import com.aspose.html.internal.ms.System.Xml.XPathNavigator;
import com.aspose.html.internal.ms.System.Xml.XPathParser;
import com.aspose.html.internal.ms.System.Xml.XPathVariableBinding;
import com.aspose.html.internal.ms.System.Xml.XmlConvert;
import com.aspose.html.internal.ms.System.Xml.XmlException;
import com.aspose.html.internal.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlResolver;
import com.aspose.html.internal.ms.System.Xml.XmlTextReaderInternal;
import com.aspose.html.internal.ms.System.Xml.XmlUrlResolver;
import com.aspose.html.internal.ms.System.Xml.XmlValidatingReader;
import com.aspose.html.internal.ms.System.Xml.XslAttributeSet;
import com.aspose.html.internal.ms.System.Xml.XslAvt;
import com.aspose.html.internal.ms.System.Xml.XslDecimalFormat;
import com.aspose.html.internal.ms.System.Xml.XslGlobalVariable;
import com.aspose.html.internal.ms.System.Xml.XslKey;
import com.aspose.html.internal.ms.System.Xml.XslLocalVariable;
import com.aspose.html.internal.ms.System.Xml.XslNameUtil;
import com.aspose.html.internal.ms.System.Xml.XslOperation;
import com.aspose.html.internal.ms.System.Xml.XslOutput;
import com.aspose.html.internal.ms.System.Xml.XslStylesheet;
import com.aspose.html.internal.ms.System.Xml.XslTemplateContent;
import com.aspose.html.internal.ms.System.Xml.XsltCompileException;
import com.aspose.html.internal.ms.System.Xml.XsltCurrent;
import com.aspose.html.internal.ms.System.Xml.XsltDebuggerWrapper;
import com.aspose.html.internal.ms.System.Xml.XsltDocument;
import com.aspose.html.internal.ms.System.Xml.XsltElementAvailable;
import com.aspose.html.internal.ms.System.Xml.XsltFormatNumber;
import com.aspose.html.internal.ms.System.Xml.XsltFunctionAvailable;
import com.aspose.html.internal.ms.System.Xml.XsltGenerateId;
import com.aspose.html.internal.ms.System.Xml.XsltKey;
import com.aspose.html.internal.ms.System.Xml.XsltPatternParser;
import com.aspose.html.internal.ms.System.Xml.XsltSystemProperty;
import com.aspose.html.internal.ms.System.Xml.XsltUnparsedEntityUri;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

class Compiler
implements IStaticXsltContext {
    public static final String XsltNamespace = "http://www.w3.org/1999/XSL/Transform";
    private ArrayList a = new ArrayList();
    private XPathNavigator b;
    private Stack c = new Stack();
    private XslStylesheet d;
    private Hashtable e = new Hashtable();
    private Hashtable f = new Hashtable();
    private Hashtable g = new Hashtable();
    private XmlNamespaceManager h = new XmlNamespaceManager(new NameTable());
    private XmlResolver i;
    private Evidence j;
    private XslStylesheet k;
    private Hashtable l = new Hashtable();
    private boolean m;
    private String n;
    private XsltDebuggerWrapper o;
    private MSXslScriptManager p = new MSXslScriptManager();
    XPathParser xpathParser;
    XsltPatternParser patternParser;
    private VariableScope q;
    private Hashtable r = new Hashtable();
    private static final StringSwitchMap s = new StringSwitchMap("yes", "no", "current", "unparsed-entity-uri", "element-available", "system-property", "function-available", "generate-id", "format-number", "key", "document");

    public Compiler(Object debugger) {
        if (debugger != null) {
            this.o = new XsltDebuggerWrapper(debugger);
        }
    }

    public XsltDebuggerWrapper getDebugger() {
        return this.o;
    }

    public void checkExtraAttributes(String element, String ... validNames) {
        if (this.getInput().moveToFirstAttribute()) {
            do {
                if (this.getInput().getNamespaceURI().length() > 0) continue;
                boolean bl2 = false;
                for (String string : validNames) {
                    if (!StringExtensions.equals(this.getInput().getLocalName(), string)) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                throw new XsltCompileException(StringExtensions.format("Invalid attribute '{0}' on element '{1}'", this.getInput().getLocalName(), element), null, this.getInput());
            } while (this.getInput().moveToNextAttribute());
            this.getInput().moveToParent();
        }
    }

    public CompiledStylesheet compile(XPathNavigator nav, XmlResolver res, Evidence evidence) {
        this.xpathParser = new XPathParser(this);
        this.patternParser = new XsltPatternParser(this);
        this.i = res;
        if (res == null) {
            this.i = new XmlUrlResolver();
        }
        this.j = evidence;
        if (nav.getNodeType() == 0 && !nav.moveToFirstChild()) {
            throw new XsltCompileException("Stylesheet root element must be either \"stylesheet\" or \"transform\" or any literal element", null, nav);
        }
        while (nav.getNodeType() != 1) {
            nav.moveToNext();
        }
        this.n = nav.getAttribute("version", !XsltNamespace.equals(nav.getNamespaceURI()) ? XsltNamespace : StringExtensions.Empty);
        this.l.set_Item("", new XslOutput("", this.n));
        this.pushInputDocument(nav);
        if (nav.moveToFirstNamespace(1)) {
            do {
                this.h.addNamespace(nav.getLocalName(), nav.getValue());
            } while (nav.moveToNextNamespace(1));
            nav.moveToParent();
        }
        try {
            this.k = new XslStylesheet();
            this.k.compile(this);
        }
        catch (XsltCompileException xsltCompileException) {
            throw xsltCompileException;
        }
        catch (Exception exception) {
            throw new XsltCompileException(StringExtensions.concat("XSLT compile error. ", exception.getMessage()), exception, this.getInput());
        }
        return new CompiledStylesheet(this.k, this.f, this.g, this.h, this.e, this.l, this.r, this.p);
    }

    public MSXslScriptManager getScriptManager() {
        return this.p;
    }

    public boolean getKeyCompilationMode() {
        return this.m;
    }

    public void setKeyCompilationMode(boolean value) {
        this.m = value;
    }

    Evidence getEvidence() {
        return this.j;
    }

    public XPathNavigator getInput() {
        return this.b;
    }

    public XslStylesheet getCurrentStylesheet() {
        return this.d;
    }

    public void pushStylesheet(XslStylesheet style) {
        if (this.d != null) {
            this.c.push(this.d);
        }
        this.d = style;
    }

    public void popStylesheet() {
        this.d = this.c.size() == 0 ? null : (XslStylesheet)this.c.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushInputDocument(String url) {
        Uri uri = StringExtensions.equals(this.getInput().getBaseURI(), StringExtensions.Empty) ? null : new Uri(this.getInput().getBaseURI());
        Uri uri2 = this.i.resolveUri(uri, url);
        String string = uri2 != null ? uri2.toString() : StringExtensions.Empty;
        Stream stream = (Stream)this.i.getEntity(uri2, null, Operators.typeOf(Stream.class));
        try {
            if (stream == null) {
                throw new XsltCompileException(StringExtensions.concat("Can not access URI ", uri2.toString()), null, this.getInput());
            }
            XmlValidatingReader xmlValidatingReader = new XmlValidatingReader(new XmlTextReaderInternal(string, stream, this.h.getNameTable()));
            xmlValidatingReader.setValidationType(0);
            XPathNavigator xPathNavigator = new XPathDocument(xmlValidatingReader, 2).createNavigator();
            xmlValidatingReader.close();
            xPathNavigator.moveToFirstChild();
            while (xPathNavigator.getNodeType() != 1 && xPathNavigator.moveToNext()) {
            }
            this.pushInputDocument(xPathNavigator);
        }
        finally {
            if (stream != null) {
                stream.dispose();
            }
        }
    }

    public void pushInputDocument(XPathNavigator nav) {
        IXmlLineInfo iXmlLineInfo = this.b instanceof IXmlLineInfo ? (IXmlLineInfo)((Object)this.b) : null;
        boolean bl2 = iXmlLineInfo != null && !iXmlLineInfo.hasLineInfo();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            XPathNavigator xPathNavigator = (XPathNavigator)this.a.get_Item(i2);
            if (!StringExtensions.equals(xPathNavigator.getBaseURI(), nav.getBaseURI())) continue;
            throw new XsltCompileException(null, this.b.getBaseURI(), bl2 ? iXmlLineInfo.getLineNumber() : 0, bl2 ? iXmlLineInfo.getLinePosition() : 0);
        }
        if (this.b != null) {
            this.a.addItem(this.b);
        }
        this.b = nav;
    }

    public void popInputDocument() {
        int n2 = this.a.size() - 1;
        this.b = (XPathNavigator)this.a.get_Item(n2);
        this.a.removeAt(n2);
    }

    public XmlQualifiedName parseQNameAttribute(String localName) {
        return this.parseQNameAttribute(localName, StringExtensions.Empty);
    }

    public XmlQualifiedName parseQNameAttribute(String localName, String ns) {
        return XslNameUtil.fromString(this.getInput().getAttribute(localName, ns), this.getInput());
    }

    public XmlQualifiedName[] parseQNameListAttribute(String localName) {
        return this.parseQNameListAttribute(localName, StringExtensions.Empty);
    }

    public XmlQualifiedName[] parseQNameListAttribute(String localName, String ns) {
        String string = this.getAttribute(localName, ns);
        if (string == null) {
            return null;
        }
        String[] stringArray = StringExtensions.split(string, ' ', '\r', '\n', '\t');
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].length() == 0) continue;
            ++n2;
        }
        XmlQualifiedName[] xmlQualifiedNameArray = new XmlQualifiedName[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (stringArray[i3].length() == 0) continue;
            xmlQualifiedNameArray[n3++] = XslNameUtil.fromString(stringArray[i3], this.getInput());
        }
        return xmlQualifiedNameArray;
    }

    public boolean parseYesNoAttribute(String localName, boolean defaultVal) {
        return this.parseYesNoAttribute(localName, StringExtensions.Empty, defaultVal);
    }

    public boolean parseYesNoAttribute(String localName, String ns, boolean defaultVal) {
        String string = this.getAttribute(localName, ns);
        if (string == null) {
            return defaultVal;
        }
        switch (s.of(string)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        throw new XsltCompileException(StringExtensions.concat("Invalid value for ", localName), null, this.getInput());
    }

    public String getAttribute(String localName) {
        return this.getAttribute(localName, StringExtensions.Empty);
    }

    public String getAttribute(String localName, String ns) {
        if (!this.getInput().moveToAttribute(localName, ns)) {
            return null;
        }
        String string = this.getInput().getValue();
        this.getInput().moveToParent();
        return string;
    }

    public XslAvt parseAvtAttribute(String localName) {
        return this.parseAvtAttribute(localName, StringExtensions.Empty);
    }

    public XslAvt parseAvtAttribute(String localName, String ns) {
        return this.parseAvt(this.getAttribute(localName, ns));
    }

    public void assertAttribute(String localName) {
        this.assertAttribute(localName, "");
    }

    public void assertAttribute(String localName, String ns) {
        if (this.getInput().getAttribute(localName, ns) == null) {
            throw new XsltCompileException(StringExtensions.concat("Was expecting the ", localName, " attribute"), null, this.getInput());
        }
    }

    public XslAvt parseAvt(String s2) {
        if (s2 == null) {
            return null;
        }
        return new XslAvt(s2, this);
    }

    public Pattern compilePattern(String pattern, XPathNavigator loc) {
        if (pattern == null || "".equals(pattern)) {
            return null;
        }
        Pattern pattern2 = Pattern.compile(pattern, this);
        if (pattern2 == null) {
            throw new XsltCompileException(StringExtensions.format("Invalid pattern '{0}'", pattern), null, loc);
        }
        return pattern2;
    }

    CompiledExpression compileExpression(String expression) {
        return this.compileExpression(expression, false);
    }

    CompiledExpression compileExpression(String expression, boolean isKey) {
        if (expression == null || "".equals(expression)) {
            return null;
        }
        Expression expression2 = this.xpathParser.compile(expression);
        if (isKey) {
            expression2 = new ExprKeyContainer(expression2);
        }
        CompiledExpression compiledExpression = new CompiledExpression(expression, expression2);
        return compiledExpression;
    }

    public XslOperation compileTemplateContent() {
        return this.compileTemplateContent(9, false);
    }

    public XslOperation compileTemplateContent(int parentType) {
        return this.compileTemplateContent(parentType, false);
    }

    public XslOperation compileTemplateContent(int parentType, boolean xslForEach) {
        return new XslTemplateContent(this, parentType, xslForEach);
    }

    public void addGlobalVariable(XslGlobalVariable var) {
        this.f.set_Item(var.getName(), var);
    }

    public void addKey(XslKey key) {
        if (this.e.get_Item(key.getName()) == null) {
            this.e.set_Item(key.getName(), new ArrayList());
        }
        ((ArrayList)this.e.get_Item(key.getName())).addItem(key);
    }

    public void addAttributeSet(XslAttributeSet set) {
        XslAttributeSet xslAttributeSet;
        Object object = this.g.get_Item(set.getName());
        XslAttributeSet xslAttributeSet2 = xslAttributeSet = object instanceof XslAttributeSet ? (XslAttributeSet)object : null;
        if (xslAttributeSet != null) {
            xslAttributeSet.merge(set);
            this.g.set_Item(set.getName(), xslAttributeSet);
        } else {
            this.g.set_Item(set.getName(), set);
        }
    }

    public void pushScope() {
        this.q = new VariableScope(this.q);
    }

    public VariableScope popScope() {
        this.q.giveHighTideToParent();
        VariableScope variableScope = this.q;
        this.q = this.q.getParent();
        return variableScope;
    }

    public int addVariable(XslLocalVariable v2) {
        if (this.q == null) {
            throw new XsltCompileException("Not initialized variable", null, this.getInput());
        }
        return this.q.addVariable(v2);
    }

    public VariableScope getCurrentVariableScope() {
        return this.q;
    }

    public boolean isExtensionNamespace(String nsUri) {
        if (XsltNamespace.equals(nsUri)) {
            return true;
        }
        XPathNavigator xPathNavigator = this.getInput().deepClone();
        XPathNavigator xPathNavigator2 = xPathNavigator.deepClone();
        do {
            boolean bl2 = XsltNamespace.equals(xPathNavigator.getNamespaceURI());
            xPathNavigator2.moveTo(xPathNavigator);
            if (!xPathNavigator.moveToFirstAttribute()) continue;
            do {
                if (!"extension-element-prefixes".equals(xPathNavigator.getLocalName()) || !StringExtensions.equals(xPathNavigator.getNamespaceURI(), bl2 ? StringExtensions.Empty : XsltNamespace)) continue;
                for (String string : StringExtensions.split(xPathNavigator.getValue(), ' ')) {
                    if (!StringExtensions.equals(xPathNavigator2.getNamespace("#default".equals(string) ? "" : string), nsUri)) continue;
                    return true;
                }
            } while (xPathNavigator.moveToNextAttribute());
            xPathNavigator.moveToParent();
        } while (xPathNavigator.moveToParent());
        return false;
    }

    public Hashtable getNamespacesToCopy() {
        Hashtable hashtable = new Hashtable();
        XPathNavigator xPathNavigator = this.getInput().deepClone();
        XPathNavigator xPathNavigator2 = xPathNavigator.deepClone();
        if (xPathNavigator.moveToFirstNamespace(1)) {
            do {
                if (XsltNamespace.equals(xPathNavigator.getValue()) || hashtable.contains(xPathNavigator.getName())) continue;
                hashtable.addItem(xPathNavigator.getName(), xPathNavigator.getValue());
            } while (xPathNavigator.moveToNextNamespace(1));
            xPathNavigator.moveToParent();
        }
        do {
            boolean bl2 = XsltNamespace.equals(xPathNavigator.getNamespaceURI());
            xPathNavigator2.moveTo(xPathNavigator);
            if (!xPathNavigator.moveToFirstAttribute()) continue;
            do {
                if (!"extension-element-prefixes".equals(xPathNavigator.getLocalName()) && !"exclude-result-prefixes".equals(xPathNavigator.getLocalName()) || !StringExtensions.equals(xPathNavigator.getNamespaceURI(), bl2 ? StringExtensions.Empty : XsltNamespace)) continue;
                for (String string : StringExtensions.split(xPathNavigator.getValue(), ' ')) {
                    String string2;
                    String string3 = string2 = "#default".equals(string) ? "" : string;
                    if (!StringExtensions.equals((String)hashtable.get_Item(string2), xPathNavigator2.getNamespace(string2))) continue;
                    hashtable.removeItem(string2);
                }
            } while (xPathNavigator.moveToNextAttribute());
            xPathNavigator.moveToParent();
        } while (xPathNavigator.moveToParent());
        return hashtable;
    }

    public void compileDecimalFormat() {
        XmlQualifiedName xmlQualifiedName = this.parseQNameAttribute("name");
        try {
            if (!StringExtensions.equals(xmlQualifiedName.getName(), StringExtensions.Empty)) {
                XmlConvert.verifyNCName(xmlQualifiedName.getName());
            }
        }
        catch (XmlException xmlException) {
            throw new XsltCompileException("Invalid qualified name", xmlException, this.getInput());
        }
        XslDecimalFormat xslDecimalFormat = new XslDecimalFormat(this);
        if (this.r.contains(xmlQualifiedName)) {
            ((XslDecimalFormat)this.r.get_Item(xmlQualifiedName)).checkSameAs(xslDecimalFormat);
        } else {
            this.r.set_Item(xmlQualifiedName, xslDecimalFormat);
        }
    }

    @Override
    public Expression tryGetVariable(String nm) {
        if (this.q == null) {
            return null;
        }
        XslLocalVariable xslLocalVariable = this.q.resolveStatic(XslNameUtil.fromString(nm, this.getInput()));
        if (xslLocalVariable == null) {
            return null;
        }
        return new XPathVariableBinding(xslLocalVariable);
    }

    @Override
    public Expression tryGetFunction(XmlQualifiedName name, FunctionArguments args) {
        String string = this.lookupNamespace(name.getNamespace());
        if ("urn:schemas-microsoft-com:xslt".equals(string) && "node-set".equals(name.getName())) {
            return new MSXslNodeSet(args);
        }
        if (!"".equals(string)) {
            return null;
        }
        switch (s.of(name.getName())) {
            case 2: {
                return new XsltCurrent(args);
            }
            case 3: {
                return new XsltUnparsedEntityUri(args);
            }
            case 4: {
                return new XsltElementAvailable(args, this);
            }
            case 5: {
                return new XsltSystemProperty(args, this);
            }
            case 6: {
                return new XsltFunctionAvailable(args, this);
            }
            case 7: {
                return new XsltGenerateId(args);
            }
            case 8: {
                return new XsltFormatNumber(args, this);
            }
            case 9: {
                if (this.getKeyCompilationMode()) {
                    throw new XsltCompileException("Cannot use key() function inside key definition", null, this.getInput());
                }
                return new XsltKey(args, this);
            }
            case 10: {
                return new XsltDocument(args, this);
            }
        }
        return null;
    }

    @Override
    public XmlQualifiedName lookupQName(String s2) {
        return XslNameUtil.fromString(s2, this.getInput());
    }

    @Override
    public String lookupNamespace(String prefix) {
        if ("".equals(prefix) || prefix == null) {
            return "";
        }
        XPathNavigator xPathNavigator = this.getInput();
        if (this.getInput().getNodeType() == 2) {
            xPathNavigator = this.getInput().deepClone();
            xPathNavigator.moveToParent();
        }
        return xPathNavigator.getNamespace(prefix);
    }

    public void compileOutput() {
        XslOutput xslOutput;
        XPathNavigator xPathNavigator = this.getInput();
        String string = xPathNavigator.getAttribute("href", "");
        Object object = this.l.get_Item(string);
        XslOutput xslOutput2 = xslOutput = object instanceof XslOutput ? (XslOutput)object : null;
        if (xslOutput == null) {
            xslOutput = new XslOutput(string, this.n);
            this.l.addItem(string, xslOutput);
        }
        xslOutput.fill(xPathNavigator);
    }
}

