/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Text;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.Text.Decoder;
import com.aspose.html.internal.ms.System.Text.DecoderFallback;
import com.aspose.html.internal.ms.System.Text.DecoderFallbackBuffer;
import com.aspose.html.internal.ms.System.Text.Encoder;
import com.aspose.html.internal.ms.System.Text.EncoderFallback;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.mscorlib.f.a;
import com.aspose.html.internal.ms.core.mscorlib.f.g;

@SerializableAttribute
public class UTF7Encoding
extends Encoding {
    static final int a = 65000;
    private boolean n;

    public UTF7Encoding() {
        this(false);
    }

    public UTF7Encoding(boolean allowOptionals) {
        super(65000);
        this.n = allowOptionals;
        this.body_name = "utf-7";
        this.encoding_name = "Unicode (UTF-7)";
        this.header_name = "utf-7";
        this.is_mail_news_display = true;
        this.is_mail_news_save = true;
        this.web_name = "utf-7";
        this.windows_code_page = 1200;
        this.setDecoderFallback(new UTF7DecoderFallback());
    }

    @Override
    public int getByteCount(char[] chars, int index, int count) {
        g g2 = new g(this.n, this.getEncoderFallback());
        return g2.a(chars, index, count);
    }

    @Override
    public int getBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex) {
        g g2 = new g(this.n, this.getEncoderFallback());
        return g2.a(chars, charIndex, charCount, bytes, byteIndex);
    }

    @Override
    public int getCharCount(byte[] bytes, int index, int count) {
        com.aspose.html.internal.ms.core.mscorlib.e.g g2 = new com.aspose.html.internal.ms.core.mscorlib.e.g(this.getDecoderFallback());
        return g2.a(bytes, index, count);
    }

    @Override
    public int getChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex) {
        com.aspose.html.internal.ms.core.mscorlib.e.g g2 = new com.aspose.html.internal.ms.core.mscorlib.e.g(this.getDecoderFallback());
        return g2.a(bytes, byteIndex, byteCount, chars, charIndex);
    }

    @Override
    public Encoder getEncoder() {
        return new UTF7Encoder(this.n, this.getEncoderFallback());
    }

    @Override
    public Decoder getDecoder() {
        return new UTF7Decoder(this.getDecoderFallback());
    }

    @Override
    public int getMaxByteCount(int charCount) {
        if (charCount < 0) {
            throw new ArgumentOutOfRangeException("charCount", "Non-negative number required.");
        }
        return charCount * 3 + 2;
    }

    @Override
    public int getMaxCharCount(int byteCount) {
        if (byteCount < 0) {
            throw new ArgumentOutOfRangeException("byteCount", "Non-negative number required.");
        }
        return byteCount == 0 ? 1 : byteCount;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        return this.n ? -n2 : n2;
    }

    @Override
    public boolean equals(Object value) {
        UTF7Encoding uTF7Encoding = value instanceof UTF7Encoding ? (UTF7Encoding)value : null;
        return uTF7Encoding != null && this.n == uTF7Encoding.n && this.getEncoderFallback().equals(uTF7Encoding.getEncoderFallback()) && this.getDecoderFallback().equals(uTF7Encoding.getDecoderFallback());
    }

    private static class UTF7DecoderFallbackBuffer
    extends DecoderFallbackBuffer {
        private char a = '\u0000';
        private int b = -1;
        private int c;

        private UTF7DecoderFallbackBuffer() {
        }

        @Override
        public void reset() {
            this.b = -1;
        }

        @Override
        public int getRemaining() {
            return this.b > 0 ? this.b : 0;
        }

        @Override
        public boolean fallback(byte[] bytesUnknown, int index) {
            if (bytesUnknown == null) {
                throw new ArgumentNullException("bytesUnknown");
            }
            if (index < 0 || bytesUnknown.length < index) {
                throw new ArgumentOutOfRangeException("index");
            }
            if (this.b >= 0) {
                throw new ArgumentException("[UTF7DecoderFallbackBuffer.Fallback] Can't have recursive fallbacks");
            }
            if (bytesUnknown.length != 1) {
                throw new ArgumentException("[UTF7DecoderFallbackBuffer.Fallback] Only possible fallback case should be 1 unknown byte");
            }
            this.a = (char)(bytesUnknown[0] & 0xFF);
            if (this.a == '\u0000') {
                return false;
            }
            this.b = 1;
            this.c = 1;
            return true;
        }

        @Override
        public char getNextChar() {
            if (this.b-- > 0) {
                return this.a;
            }
            return '\u0000';
        }

        @Override
        public boolean movePrevious() {
            if (this.b >= 0) {
                ++this.b;
            }
            return this.b >= 0 && this.b <= this.c;
        }
    }

    private static class UTF7DecoderFallback
    extends DecoderFallback {
        private UTF7DecoderFallback() {
        }

        @Override
        public int getMaxCharCount() {
            return 1;
        }

        @Override
        public DecoderFallbackBuffer createFallbackBuffer() {
            return new UTF7DecoderFallbackBuffer();
        }
    }

    @SerializableAttribute
    private static class UTF7Decoder
    extends com.aspose.html.internal.ms.core.mscorlib.e.a {
        private UTF7Decoder(DecoderFallback fallback) {
            super(new com.aspose.html.internal.ms.core.mscorlib.e.g(fallback));
        }
    }

    @SerializableAttribute
    private static class UTF7Encoder
    extends a {
        private UTF7Encoder(boolean allowOptionals, EncoderFallback fallback) {
            super(new g(allowOptionals, fallback));
        }
    }
}

